/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.ServletContext;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringServiceLocator {
    private static final Log log = LogFactory.getLog((String)SpringServiceLocator.class.getName());
    private static ApplicationContext context = null;
    private static boolean initialized = false;

    private SpringServiceLocator() {
    }

    public static void init(ServletContext ctx) {
        if (!initialized) {
            context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)ctx);
        }
    }

    public static void init(List<String> ctxList) throws Exception {
        log.info((Object)"\n\n***** Custom initialization of SpringServiceLocator *****\n\n");
        try {
            log.info((Object)"\n\n\n===== [ Begin initializing SpringServiceLocator ] =====\n\n\n");
            if (ctxList == null) {
                log.warn((Object)"\n\n============== WARNING ================\n===== Spring app context list null  ... exiting initialization process =====\n\n");
                throw new Exception("Spring app context list null  ... exiting initialization process");
            }
            String ctx = null;
            String ctxTrim = null;
            ListIterator<String> iter = ctxList.listIterator();
            while (iter.hasNext()) {
                ctx = iter.next().trim();
                log.debug((Object)("before classpath=" + ctx));
                ctx = "classpath:" + ctx;
                log.debug((Object)("after classpath=" + ctx));
                ctxTrim = ctx.trim();
                iter.set(ctxTrim);
            }
            String[] contexts = ctxList.toArray(new String[ctxList.size()]);
            String ctxStr = null;
            for (int i = 0; i < contexts.length; ++i) {
                ctxStr = contexts[i];
                log.debug((Object)("==>Context[" + i + "]: " + ctxStr));
            }
            log.debug((Object)("Spring Context List: " + contexts));
            if (!initialized) {
                context = new ClassPathXmlApplicationContext(contexts);
                log.info((Object)"Spring context(s) initialized");
                initialized = true;
            }
        }
        catch (RuntimeException e) {
            log.error((Object)("==>RuntimeException: Fatal error during context configuration!" + e.getMessage()));
            log.error((Object)("==>RuntimeException: Fatal error during context configuration! --- cause: " + e.getCause()));
            e.printStackTrace();
            throw new ExceptionInInitializerError(e.getMessage());
        }
        catch (Throwable e) {
            log.error((Object)("==>General Exception: Fatal error during context configuration!" + e.getMessage()));
            log.error((Object)("==>General Exception: Fatal error during context configuration! --- cause: " + e.getCause()));
            e.printStackTrace();
            throw new ExceptionInInitializerError(e.getMessage());
        }
        finally {
            if (!initialized) {
                log.warn((Object)"\n\n============== WARNING ================\nCould not initialize SpringServiceLocator - problems with spring context files.\n\n");
            } else {
                log.info((Object)"\n==================================================\n==== SpringServiceLocator successfully initialized ====\n==================================================");
            }
        }
    }

    public static Object get(String name) {
        return SpringServiceLocator.get(name, null);
    }

    public static Object get(Class clazz) {
        return SpringServiceLocator.get(clazz.getName(), clazz);
    }

    public static Object get(String name, Class requiredImplementation) {
        Object target = null;
        try {
            target = requiredImplementation == null ? context.getBean(name) : context.getBean(name, requiredImplementation);
        }
        catch (Exception e) {
            log.error((Object)("==> Error getting bean from spring context: " + name), (Throwable)e);
        }
        return target;
    }

    public static String[] getBeanDefinitionNames() {
        return context.getBeanDefinitionNames();
    }

    public static boolean containsBean(String name) {
        return context.containsBean(name);
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static SessionFactory getHibernateSessionFactory() {
        return (SessionFactory)SpringServiceLocator.get("hibernateSessionFactory");
    }

    public static void destroyContext() {
        if (context != null && context instanceof ClassPathXmlApplicationContext) {
            ((ClassPathXmlApplicationContext)context).close();
        }
    }

    public static void main(String[] args) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initialiazed, getting args[0]");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("args[0] = " + SpringServiceLocator.get(args[0])));
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                System.out.print("Bean to get or 'l' to list: ");
                String line = in.readLine();
                if (!"l".equals(line)) {
                    Object o = SpringServiceLocator.get(line);
                    if (!log.isDebugEnabled()) continue;
                    log.debug(o);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)ToStringBuilder.reflectionToString((Object)context.getBeanDefinitionNames()));
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

