/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.util.TextResources;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ResourceUtils {
    private static final Logger log = Logger.getLogger((String)ResourceUtils.class.getName());
    private static Map<String, TextResources> resourceMap = new HashMap<String, TextResources>();
    private static Map<String, TextResources> configResourceMap = new HashMap<String, TextResources>();

    private ResourceUtils() {
    }

    public static void loadResource(String key, String resourceName) {
        ResourceUtils.loadResource(key, resourceName, resourceMap);
    }

    public static void loadResource(String resourceName) {
        ResourceUtils.loadResource("DEFAULT", resourceName, resourceMap);
    }

    public static void loadConfigResource(String key, String resourceName) {
        ResourceUtils.loadResource(key, resourceName, configResourceMap);
    }

    public static void loadConfigResource(String resourceName) {
        ResourceUtils.loadResource("DEFAULT", resourceName, configResourceMap);
    }

    public static void addResource(String key, ResourceBundle resource) {
        ResourceUtils.addResource(key, new TextResources(resource), resourceMap);
    }

    public static void addResource(ResourceBundle resource) {
        ResourceUtils.addResource("DEFAULT", new TextResources(resource), resourceMap);
    }

    public static void addConfigResource(String key, ResourceBundle resource) {
        ResourceUtils.addResource(key, new TextResources(resource), configResourceMap);
    }

    public static void addConfigResource(ResourceBundle resource) {
        ResourceUtils.addResource("DEFAULT", new TextResources(resource), configResourceMap);
    }

    public static void removeResource(String key) {
        if (!StringUtils.isBlank((String)key)) {
            resourceMap.remove(key.toUpperCase());
        }
    }

    public static void removeConfigResource(String key) {
        if (!StringUtils.isBlank((String)key)) {
            configResourceMap.remove(key.toUpperCase());
        }
    }

    public static TextResources getResource(String key) {
        return ResourceUtils.getResource(key, resourceMap);
    }

    public static TextResources getResource() {
        return ResourceUtils.getResource("DEFAULT", resourceMap);
    }

    public static TextResources getConfigResource(String key) {
        return ResourceUtils.getResource(key, configResourceMap);
    }

    public static TextResources getConfigResource() {
        return ResourceUtils.getResource("DEFAULT", configResourceMap);
    }

    private static void loadResource(String key, String resourceName, Map<String, TextResources> map) {
        try {
            PropertyResourceBundle resource = (PropertyResourceBundle)PropertyResourceBundle.getBundle(resourceName);
            log.error((Object)("resource=" + resource));
            ResourceUtils.addResource(key, new TextResources(resource), map);
        }
        catch (NullPointerException npe) {
            log.error((Object)("ERROR:\n" + npe.toString()));
        }
        catch (MissingResourceException mre) {
            log.error((Object)("ERROR:\n" + mre.toString()));
        }
    }

    private static void addResource(String key, TextResources resource, Map<String, TextResources> map) {
        if (resource == null) {
            log.warn((Object)"** RESOURCE IS NULL :: NOT ADDING RESOURCE **");
        }
        if (StringUtils.isBlank((String)key)) {
            log.warn((Object)"** KEY IS NULL :: NOT ADDING RESOURCE **");
        }
        map.put(key.toUpperCase(), resource);
    }

    private static TextResources getResource(String key, Map<String, TextResources> map) {
        TextResources resource = null;
        if (!StringUtils.isBlank((String)key) && (resource = map.get(key.toUpperCase())) == null) {
            resource = map.get("DEFAULT");
        }
        return resource;
    }
}

