/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ResourceLocator {
    private static final Logger log = Logger.getLogger((String)ResourceLocator.class.getName());
    private String resourceName = null;
    private File file = null;
    private URL url = null;

    public ResourceLocator() {
    }

    public ResourceLocator(String resourceName) throws IOException {
        this.init(resourceName);
    }

    public void init(String resourceName) throws IOException {
        this.reset();
        this.resourceName = resourceName;
        SecurityException exception = null;
        try {
            if (this.tryClasspath(resourceName)) {
                log.debug((Object)"Resource found in CLASSPATH");
                return;
            }
        }
        catch (SecurityException e) {
            exception = e;
        }
        try {
            if (this.tryLoader(resourceName)) {
                log.debug((Object)"Resource found using the classloader getResource()");
                return;
            }
        }
        catch (SecurityException e) {
            log.error((Object)("SecurityException Caught:\n" + e));
            exception = e;
        }
        if (this.tryFilesystem(resourceName)) {
            log.debug((Object)("Resource found in filesystem: " + resourceName));
            return;
        }
        String msg = "";
        if (exception != null) {
            msg = ": " + exception;
        }
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("Resource '").append(resourceName).append("' could not be found in the CLASSPATH:\n").append(System.getProperty("java.class.path")).append("\n\n nor could it be located by the classloader responsible for the web application (WEB-INF/classes)").append(msg);
        log.error((Object)errorMsg.toString());
        throw new IOException(errorMsg.toString());
    }

    public void reset() {
        log.debug((Object)"Resetting ResourceLocator");
        this.file = null;
        this.url = null;
        this.resourceName = null;
    }

    public InputStream findResource(String resourceName) {
        return this.getClass().getClassLoader().getResourceAsStream(resourceName);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        if (this.url != null) {
            return new BufferedInputStream(this.url.openStream());
        }
        return null;
    }

    public long lastModified() {
        if (this.file != null) {
            return this.file.lastModified();
        }
        if (this.url != null) {
            try {
                return this.url.openConnection().getLastModified();
            }
            catch (IOException e) {
                return Long.MAX_VALUE;
            }
        }
        return 0L;
    }

    public String getDirectory() {
        if (this.file != null) {
            return this.file.getParent();
        }
        if (this.url != null) {
            return null;
        }
        return null;
    }

    private boolean tryClasspath(String filename) {
        String classpath = System.getProperty("java.class.path");
        log.debug((Object)("\n\n==>CLASSPATH=\n" + classpath + "\n\n"));
        String[] paths = ResourceLocator.split(classpath, File.pathSeparator);
        this.file = ResourceLocator.searchDirectories(paths, filename);
        return this.file != null;
    }

    private static File searchDirectories(String[] paths, String filename) {
        SecurityException exception = null;
        File file = null;
        for (int i = 0; i < paths.length; ++i) {
            try {
                file = new File(paths[i], filename);
                if (!file.exists() || file.isDirectory()) continue;
                return file;
            }
            catch (SecurityException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    private static String[] split(String str, String delim) {
        Vector<String> v = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        while (tokenizer.hasMoreTokens()) {
            v.addElement(tokenizer.nextToken());
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    private boolean tryLoader(String name) {
        name = "/" + name;
        URL res = ResourceLocator.class.getResource(name);
        if (res == null) {
            return false;
        }
        File resFile = ResourceLocator.urlToFile(res);
        if (resFile != null) {
            this.file = resFile;
        } else {
            this.url = res;
        }
        return true;
    }

    private static File urlToFile(URL res) {
        String externalForm = res.toExternalForm();
        if (externalForm.startsWith("file:")) {
            return new File(externalForm.substring(5));
        }
        return null;
    }

    private boolean tryFilesystem(String name) {
        this.file = new File(name);
        return this.file.exists() && this.file.isFile();
    }

    public String toString() {
        return "[Resource: File: " + this.file + " URL: " + this.url + "]";
    }
}

