/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class RequestUtils {
    static final Logger log = Logger.getLogger((String)RequestUtils.class.getName());

    private RequestUtils() {
    }

    public static void addErrorImage(HttpServletRequest request, String fieldName) {
        RequestUtils.addErrorImage(request, fieldName, "InvalidFormFields");
    }

    public static void addErrorImage(HttpServletRequest request, String fieldName, String hashKey) {
        HashMap<String, String> images = (HashMap<String, String>)request.getAttribute(hashKey);
        if (images == null) {
            images = new HashMap<String, String>();
        }
        images.put(fieldName, "INVALID_FIELD");
        request.setAttribute(hashKey, images);
    }

    public static Locale getUserLocale(HttpServletRequest request, String locale) {
        Locale userLocale = null;
        HttpSession session = request.getSession(false);
        if (locale == null) {
            locale = "LOCALE_KEY";
        }
        if (session != null) {
            userLocale = (Locale)session.getAttribute(locale);
        }
        if (userLocale == null) {
            userLocale = request.getLocale();
        }
        return userLocale;
    }

    public static String getFullUrl(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            url.append('?');
            url.append(queryString);
        }
        return url.toString();
    }

    public static Map<String, String> getHeaderInfo(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            map.put(key, value);
        }
        return map;
    }
}

