/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.util.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RegexUtil {
    private static final Logger log = Logger.getLogger((String)RegexUtil.class.getName());
    private Timer timer;

    private RegexUtil() {
    }

    public static boolean matches(String regex, String s) {
        Pattern mask = Pattern.compile(regex);
        Matcher matcher = mask.matcher(s);
        if (!matcher.matches()) {
            log.debug((Object)("INVALID/NO MATCH: " + s));
            return false;
        }
        log.debug((Object)("VALID/MATCH: " + s));
        return true;
    }

    public static boolean isValid(String regex, String s) {
        return RegexUtil.matches(regex, s);
    }

    public static boolean contains(String regex, String s) {
        Pattern mask = Pattern.compile(regex);
        Matcher matcher = mask.matcher(s);
        if (matcher.find()) {
            log.debug((Object)("match: " + matcher.group(0)));
            return true;
        }
        log.debug((Object)"not found");
        return false;
    }

    public static List<String> findMatches(String s, String regex, boolean trimMatchResult) {
        ArrayList<String> matches = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)s)) {
            log.debug((Object)"Match string is blank");
            return matches;
        }
        if (StringUtils.isBlank((CharSequence)regex)) {
            log.debug((Object)"Regex is blank");
            return matches;
        }
        try {
            Pattern p = null;
            p = Pattern.compile(regex);
            Matcher m = p.matcher(s);
            while (m.find()) {
                if (trimMatchResult) {
                    matches.add(m.group().trim());
                    continue;
                }
                matches.add(m.group());
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
        }
        log.debug((Object)("returning matches: " + matches));
        return matches;
    }

    public static List<String> findMatchesWithGroups(String s, String regex, boolean trimMatchResult) {
        ArrayList<String> matches = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)s)) {
            log.debug((Object)"Match string is blank");
            return matches;
        }
        if (StringUtils.isBlank((CharSequence)regex)) {
            log.debug((Object)"Regex is blank");
            return matches;
        }
        try {
            Pattern p = null;
            p = Pattern.compile(regex);
            Matcher m = p.matcher(s);
            String groupValue = null;
            while (m.find()) {
                if (m.groupCount() <= 0) continue;
                for (int i = 1; i <= m.groupCount(); ++i) {
                    groupValue = m.group(i);
                    if (trimMatchResult) {
                        matches.add(StringUtils.isBlank((CharSequence)groupValue) ? "" : groupValue.trim());
                        continue;
                    }
                    matches.add(StringUtils.isBlank((CharSequence)groupValue) ? "" : groupValue);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getMessage()));
            e.printStackTrace();
        }
        return matches;
    }
}

