/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class PropertyUtil {
    private static final Logger log = Logger.getLogger((String)PropertyUtil.class.getName());
    public static final String PIPE_DELIMITER = "|";
    public static final String COMMA_DELIMITER = ",";
    public static final String EQUAL_SIGN_DELIMITER = "=";

    private PropertyUtil() {
    }

    public static Properties convertKeyValuePairStr(String keyValueStr, String kvPairDelimiter, String kvDelimiter) {
        Properties p = new Properties();
        try {
            if (StringUtils.isBlank((CharSequence)keyValueStr) || StringUtils.isBlank((CharSequence)kvPairDelimiter) || StringUtils.isBlank((CharSequence)kvDelimiter)) {
                log.warn((Object)"key value string or one of the delimiters is null");
                return p;
            }
            String[] kvPairs = StringUtils.split((String)keyValueStr, (String)kvPairDelimiter);
            String[] kv = null;
            for (String kvPair : kvPairs) {
                kv = StringUtils.split((String)kvPair, (String)kvDelimiter);
                p.setProperty(kv[0], kv[1]);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return p;
    }
}

