/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.CommonsGlobals;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class PropertyPlaceholderUtil {
    private static final Logger log = Logger.getLogger((String)PropertyPlaceholderUtil.class.getName());
    private static final String CONFIG_DIR = CommonsGlobals.SYSTEM_CONFIG_DIR + File.separator;
    private static final String CONFIG_FILE_PATH = CONFIG_DIR + "system-config-files.properties";
    private static Properties PROPS;
    private static final String PROP_VALUE_DELIMITER = "|";

    private PropertyPlaceholderUtil() {
    }

    public static String getProperty(String key) {
        StringBuilder cleanValue = new StringBuilder();
        try {
            String rawValue = PROPS.getProperty(key);
            log.debug((Object)("raw prop value: " + rawValue));
            if (StringUtils.isBlank((CharSequence)rawValue)) {
                return rawValue;
            }
            String placeholderPattern = "";
            placeholderPattern = "\\$\\{.*?\\}";
            placeholderPattern = "\\$\\{[a-zA-Z0-9]+[a-zA-Z0-9\\.\\-_]*\\}";
            Pattern p = Pattern.compile(placeholderPattern);
            Matcher m = p.matcher(rawValue);
            int start = -1;
            int end = -1;
            String placeholder = null;
            String placeholderKey = null;
            String placeholderValue = null;
            int index = 0;
            while (m.find()) {
                start = m.start();
                end = m.end();
                log.debug((Object)("start/end: " + start + "/" + end));
                placeholder = m.group();
                log.debug((Object)("placeholder: " + placeholder));
                placeholderKey = placeholder.substring(2, placeholder.length() - 1);
                log.debug((Object)("placeholder key: " + placeholderKey));
                placeholderValue = PropertyPlaceholderUtil.getProperty(placeholderKey);
                log.debug((Object)("placeholder value: " + placeholderValue));
                if (StringUtils.isBlank((CharSequence)placeholderValue)) {
                    cleanValue.append(rawValue.substring(index, end));
                } else {
                    cleanValue.append(rawValue.substring(index, start));
                    cleanValue.append(placeholderValue);
                }
                index = end;
            }
            cleanValue.append(rawValue.substring(index));
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e));
        }
        log.debug((Object)("returning value: " + cleanValue));
        return cleanValue.toString();
    }

    public static String getProperty(String key, String defaultValue) {
        return PROPS.containsKey(key) ? PropertyPlaceholderUtil.getProperty(key) : defaultValue;
    }

    public static List<String> getPropertyAsList(String key) {
        ArrayList<String> values = new ArrayList<String>();
        return values;
    }

    private static void initProps() {
        String filePath = CONFIG_FILE_PATH;
        Properties p = null;
        String msg = null;
        try {
            String[] configFiles;
            p = new Properties();
            if (!PropertyPlaceholderUtil.loadProps(filePath, p)) {
                msg = "Cannot initialize properties: " + filePath;
                log.error((Object)msg);
                throw new Exception(msg);
            }
            PROPS = new Properties();
            String configFilesProp = p.getProperty("config.files");
            log.debug((Object)("config files prop: " + configFilesProp));
            for (String configFile : configFiles = StringUtils.split((String)configFilesProp, (String)PROP_VALUE_DELIMITER)) {
                filePath = CONFIG_DIR + configFile;
                log.debug((Object)("config file path: " + filePath));
                PropertyPlaceholderUtil.loadProps(filePath, PROPS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Exception: " + e));
        }
    }

    private static boolean loadProps(String filePath, Properties p) {
        try {
            log.debug((Object)("props file path: " + filePath));
            File f = new File(filePath);
            log.debug((Object)("file: " + f.getAbsolutePath()));
            log.debug((Object)("file exists: " + f.exists()));
            if (!f.exists()) {
                log.error((Object)("file does not exist: " + filePath));
                return false;
            }
            p.load(new FileInputStream(f));
            log.debug((Object)("property count: " + p.size()));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Exception: " + e));
            return false;
        }
    }

    static {
        PropertyPlaceholderUtil.initProps();
    }
}

