/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.bizobj.OpportunityKey;
import gov.grants.commons.test.BaseTest;
import gov.grants.commons.util.OpportunityUtil;
import gov.grants.commons.util.Timer;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpportunityUtilTest
extends BaseTest {
    private static final Logger LOG = Logger.getLogger((String)OpportunityUtilTest.class.getName());
    private Timer timer;

    @Before
    public void setUp() {
        this.timer = new Timer();
        this.timer.start();
    }

    @After
    public void tearDown() throws Exception {
        LOG.debug((Object)"--- tearDown()");
        this.timer.stop();
        LOG.debug((Object)("elapsed time(ms): " + this.timer.toMillisecondsLong()));
    }

    @Test
    public void opportunityIsOpen() {
        Date openDate = null;
        Date currentTimestamp = new Date();
        LOG.debug((Object)("today: " + currentTimestamp));
        int gracePeriod = 0;
        boolean isOpen = false;
        Calendar closeDate = Calendar.getInstance();
        isOpen = OpportunityUtil.opportunityIsOpen(openDate, null, gracePeriod, currentTimestamp);
        LOG.debug((Object)("close date is null: " + isOpen));
        Assert.assertFalse((String)"close date is null", (boolean)isOpen);
        closeDate.add(5, -1);
        isOpen = OpportunityUtil.opportunityIsOpen(openDate, closeDate.getTime(), gracePeriod, currentTimestamp);
        LOG.debug((Object)("close date in past: " + isOpen));
        Assert.assertFalse((String)"close date in past", (boolean)isOpen);
        closeDate.add(5, 1);
        isOpen = OpportunityUtil.opportunityIsOpen(openDate, closeDate.getTime(), gracePeriod, currentTimestamp);
        LOG.debug((Object)("close date in future: " + isOpen));
        Assert.assertTrue((String)"close date in future", (boolean)isOpen);
        Calendar currentTimestampCal = Calendar.getInstance();
        currentTimestampCal.setTime(currentTimestamp);
        currentTimestampCal.set(10, 23);
        currentTimestampCal.set(12, 59);
        currentTimestampCal.set(13, 59);
        closeDate.setTime(currentTimestamp);
        isOpen = OpportunityUtil.opportunityIsOpen(openDate, closeDate.getTime(), gracePeriod, currentTimestampCal.getTime());
        LOG.debug((Object)("close date same as currentTimestamp: " + isOpen));
        Assert.assertTrue((String)"close date same as currentTimestamp", (boolean)isOpen);
    }

    @Test
    public void createOpportunityPackageURL() {
        String oppNum = null;
        String cfda = null;
        String compId = null;
        OpportunityKey oppKey = null;
        String url = null;
        url = OpportunityUtil.createOpportunityPackageURL(oppKey);
        LOG.debug((Object)("url: " + url));
        Assert.assertNull((String)"opp key is null", (Object)url);
        oppNum = "par-13-087";
        compId = "multi-project-pilot";
        oppKey = new OpportunityKey(oppNum, cfda, compId);
        url = OpportunityUtil.createOpportunityPackageURL(oppKey);
        LOG.debug((Object)("url: " + url));
        Assert.assertNotNull((String)"valid opp key", (Object)url);
    }
}

