/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.bizobj.OpportunityKey;
import gov.grants.commons.bizobj.SystemConfiguration;
import gov.grants.commons.type.OpportunityStatusFilterType;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;

public class OpportunityUtil {
    private static final transient Logger log = Logger.getLogger((String)OpportunityUtil.class.getName());

    private OpportunityUtil() {
    }

    public static boolean opportunityIsOpen(Date openDate, Date closeDate, int gracePeriod, Date currentTimestamp) {
        boolean beforeClose = false;
        boolean afterOpen = false;
        Calendar endOfClosingDate = Calendar.getInstance();
        try {
            log.debug((Object)("current close date: " + closeDate));
            endOfClosingDate.setTime(closeDate);
        }
        catch (Exception e) {
            log.error((Object)("invalid close date [" + closeDate + "]: " + e.getMessage()));
            return false;
        }
        endOfClosingDate.set(10, 23);
        endOfClosingDate.set(12, 59);
        endOfClosingDate.set(13, 59);
        if (gracePeriod > 0) {
            endOfClosingDate.add(5, gracePeriod);
        }
        Date realClosingDate = endOfClosingDate.getTime();
        log.debug((Object)("adjusted close date: " + realClosingDate));
        log.debug((Object)("current timestamp: " + currentTimestamp));
        if (openDate == null || currentTimestamp.after(openDate) || currentTimestamp.equals(openDate)) {
            afterOpen = true;
        }
        if (currentTimestamp.before(realClosingDate) || currentTimestamp.equals(realClosingDate)) {
            beforeClose = true;
        }
        return afterOpen && beforeClose;
    }

    public static OpportunityStatusFilterType getOpportunityStatus(Date openDate, Date closeDate, int gracePeriod, Date currentTimestamp) {
        Calendar tmpCloseDate = Calendar.getInstance();
        try {
            log.debug((Object)("current close date: " + closeDate));
            tmpCloseDate.setTime(closeDate);
        }
        catch (Exception e) {
            log.error((Object)("invalid close date [" + closeDate + "]: " + e.getMessage()));
            return OpportunityStatusFilterType.CLOSED;
        }
        tmpCloseDate.set(10, 23);
        tmpCloseDate.set(12, 59);
        tmpCloseDate.set(13, 59);
        Date endOfCloseDate = tmpCloseDate.getTime();
        log.debug((Object)("end of close date: " + endOfCloseDate));
        log.debug((Object)("current timestamp: " + currentTimestamp));
        if (openDate != null && currentTimestamp.before(openDate)) {
            return OpportunityStatusFilterType.CLOSED;
        }
        if (currentTimestamp.after(endOfCloseDate)) {
            if (gracePeriod > 0) {
                tmpCloseDate.add(5, gracePeriod);
                Date endOfGracePeriod = tmpCloseDate.getTime();
                log.debug((Object)("end of grace period: " + endOfGracePeriod));
                if (currentTimestamp.after(endOfGracePeriod)) {
                    return OpportunityStatusFilterType.CLOSED;
                }
                return OpportunityStatusFilterType.IN_GRACE_PERIOD;
            }
            return OpportunityStatusFilterType.CLOSED;
        }
        return OpportunityStatusFilterType.OPEN;
    }

    public static String createOpportunityPackageURL(OpportunityKey oppKey) {
        if (oppKey == null) {
            log.error((Object)"opportunity key is null");
            return null;
        }
        String oppKeyStr = oppKey.getFullName();
        log.debug((Object)("opp key: " + oppKeyStr));
        StringBuilder url = new StringBuilder();
        url.append(SystemConfiguration.getValue("PUBLICROOTURL"));
        url.append(SystemConfiguration.getValue("OPPPACKAGEPATH"));
        url.append(oppKey.getFullName());
        url.append(".pdf");
        log.debug((Object)("created package URL: " + url));
        return url.toString();
    }

    public static String createOpportunityInstructionsURL(String fileNamePrefix, String fileExt) {
        log.info((Object)("file name prefix: " + fileNamePrefix));
        if (StringUtils.isBlank((String)fileNamePrefix)) {
            log.error((Object)"file name prefix is blank.");
            return null;
        }
        if (StringUtils.isBlank((String)fileExt)) {
            log.error((Object)"file extension is blank");
            return null;
        }
        StringBuilder url = new StringBuilder();
        url.append(SystemConfiguration.getValue("PUBLICROOTURL"));
        url.append(SystemConfiguration.getValue("OPPINSTRUCTIONSPATH"));
        url.append(fileNamePrefix);
        url.append("-instructions.");
        url.append(fileExt);
        log.debug((Object)("created instructions URL: " + url));
        return url.toString();
    }

    public static long getCompIdFromPkgIdStr(String pkgIdStr) {
        String s = pkgIdStr.substring(3);
        return NumberUtils.toLong((String)s);
    }
}

