/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.type.OpportunityStatusType;
import gov.grants.commons.vo.ForecastStatus;
import gov.grants.commons.vo.SynopsisStatus;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;

public class OpportunityStatusUtil {
    private static final Logger log = Logger.getLogger((String)OpportunityStatusUtil.class.getName());

    public static OpportunityStatusType calculateOppStatus(SynopsisStatus synopsis, ForecastStatus forecast) {
        OpportunityStatusType type = null;
        OpportunityStatusType synOppStatus = null;
        OpportunityStatusType forecastOppStatus = null;
        try {
            boolean hasForecast;
            boolean hasSynopsis = synopsis != null;
            boolean bl = hasForecast = forecast != null;
            if (hasSynopsis) {
                synOppStatus = OpportunityStatusUtil.calculateSynopsisOppStatus(synopsis.getPostingDate(), synopsis.getResponseDate(), synopsis.getArchiveDate());
            }
            if (hasForecast) {
                forecastOppStatus = OpportunityStatusUtil.calculateForecastOppStatus(forecast.getPostingDate(), forecast.getArchiveDate());
            }
            type = OpportunityStatusType.POSTED == synOppStatus ? synOppStatus : (OpportunityStatusType.FORECASTED == forecastOppStatus ? forecastOppStatus : (synOppStatus != null ? synOppStatus : forecastOppStatus));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        log.debug((Object)("returning opp status: " + type));
        return type;
    }

    public static OpportunityStatusType calculateSynopsisOppStatus(String postDate, String closeDate, String archiveDate) {
        Date post = postDate == null ? null : OpportunityStatusUtil.getDate(postDate, OpportunityStatusType.POSTED);
        Date close = closeDate == null ? null : OpportunityStatusUtil.getDate(closeDate, OpportunityStatusType.CLOSED);
        Date archive = archiveDate == null ? null : OpportunityStatusUtil.getDate(archiveDate, OpportunityStatusType.ARCHIVED);
        return OpportunityStatusUtil.calculateSynopsisOppStatus(post, close, archive);
    }

    public static OpportunityStatusType calculateSynopsisOppStatus(Date postDate, Date closeDate, Date archiveDate) {
        long archive;
        OpportunityStatusType type = null;
        long now = new Date().getTime();
        long post = postDate == null ? 0L : postDate.getTime();
        long close = closeDate == null ? 0L : closeDate.getTime();
        long l = archive = archiveDate == null ? 0L : archiveDate.getTime();
        if (post < now) {
            type = OpportunityStatusType.POSTED;
            if (close > 0L && close < now) {
                type = OpportunityStatusType.CLOSED;
            }
            if (archive > 0L && archive < now) {
                type = OpportunityStatusType.ARCHIVED;
            }
        }
        log.debug((Object)("opp status: " + (Object)((Object)type)));
        return type;
    }

    public static OpportunityStatusType calculateForecastOppStatus(String forecastPostDate, String forecastArchiveDate) {
        Date post = forecastPostDate == null ? null : OpportunityStatusUtil.getDate(forecastPostDate, OpportunityStatusType.POSTED);
        Date archive = forecastArchiveDate == null ? null : OpportunityStatusUtil.getDate(forecastArchiveDate, OpportunityStatusType.ARCHIVED);
        return OpportunityStatusUtil.calculateForecastOppStatus(post, archive);
    }

    public static OpportunityStatusType calculateForecastOppStatus(Date forecastPostDate, Date forecastArchiveDate) {
        OpportunityStatusType type = null;
        log.debug((Object)("forecast post/archive dates: " + forecastPostDate + "/" + forecastArchiveDate));
        long now = new Date().getTime();
        long post = forecastPostDate == null ? 0L : OpportunityStatusUtil.updateDate(forecastPostDate, OpportunityStatusType.POSTED).getTime();
        long archive = forecastArchiveDate == null ? 0L : OpportunityStatusUtil.updateDate(forecastArchiveDate, OpportunityStatusType.ARCHIVED).getTime();
        log.debug((Object)("now|post|archive: " + now + "|" + post + "||" + archive));
        if (post < now) {
            type = archive > 0L && archive < now ? OpportunityStatusType.ARCHIVED : OpportunityStatusType.FORECASTED;
        }
        log.debug((Object)("forecast opp status: " + (Object)((Object)type)));
        return type;
    }

    public static Date getDate(String yyyyMMdd, OpportunityStatusType type) {
        String[] details = StringUtils.split((String)yyyyMMdd, (String)"-");
        Calendar c = Calendar.getInstance();
        c.set(1, NumberUtils.toInt((String)details[0]));
        c.set(2, NumberUtils.toInt((String)details[1]) - 1);
        c.set(5, NumberUtils.toInt((String)details[2]));
        switch (type) {
            case POSTED: {
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
                break;
            }
            case CLOSED: {
                c.set(11, 23);
                c.set(12, 59);
                c.set(13, 59);
                break;
            }
            case ARCHIVED: {
                c.set(11, 23);
                c.set(12, 59);
                c.set(13, 59);
                break;
            }
            case FORECASTED: {
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
            }
        }
        log.debug((Object)((Object)((Object)type) + " > " + yyyyMMdd + "=" + c.getTime()));
        return c.getTime();
    }

    public static Date updateDate(Date d, OpportunityStatusType type) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        switch (type) {
            case POSTED: {
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
                break;
            }
            case CLOSED: {
                c.set(11, 23);
                c.set(12, 59);
                c.set(13, 59);
                break;
            }
            case ARCHIVED: {
                c.set(11, 23);
                c.set(12, 59);
                c.set(13, 59);
                break;
            }
            case FORECASTED: {
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
            }
        }
        log.debug((Object)((Object)((Object)type) + " > updated date=" + c.getTime()));
        return c.getTime();
    }
}

