/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.bizobj.NavigationItem;
import gov.grants.commons.bizobj.SystemConfiguration;
import gov.grants.commons.dao.HibernateGenericsDAO;
import gov.grants.commons.dao.NamedQueryParam;
import gov.grants.commons.dao.QueryParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;

public class NavigationUtil
implements Job {
    private static final Logger log = Logger.getLogger((String)NavigationUtil.class.getName());
    private static final int GID = 19;
    private static final String GROUPID = "groupId";
    private static final String NAMED_QUERY = "callSelectNavItemsSP";
    private static final String NAV_QUERY = "from NavigationItem ";
    private static List<NavigationItem> NAV_ITEMS = new ArrayList<NavigationItem>();
    private static List<NavigationItem> TOP_NAV_ITEMS = new ArrayList<NavigationItem>();
    private static List<NavigationItem> NAV_ITEMS_TEMP = new ArrayList<NavigationItem>();
    private static List<NavigationItem> TOP_NAV_ITEMS_TEMP = new ArrayList<NavigationItem>();
    private static Map<String, ArrayList<NavigationItem>> NAVITEM_MAP = new HashMap<String, ArrayList<NavigationItem>>();
    private static Map<String, ArrayList<NavigationItem>> NAVITEM_MAP_TEMP = new HashMap<String, ArrayList<NavigationItem>>();

    private static void initScheduler() {
        try {
            StdSchedulerFactory sf = new StdSchedulerFactory();
            Scheduler sched = sf.getScheduler();
            sched.start();
            JobDetail jd = new JobDetail("NavigationUtil", null, NavigationUtil.class);
            Integer refreshInterval = SystemConfiguration.getInt("REFRESHINTERVAL");
            log.debug((Object)("RefreshInterval: " + refreshInterval));
            Trigger t = TriggerUtils.makeMinutelyTrigger((int)refreshInterval);
            t.setStartTime(new Date(System.currentTimeMillis() + (long)(refreshInterval * 60 * 1000)));
            t.setName("NavigationUtilTrigger");
            sched.scheduleJob(jd, t);
            log.debug((Object)"job created");
        }
        catch (Exception e) {
            log.debug((Object)("Exception: " + e.getMessage()));
        }
    }

    public void execute(JobExecutionContext ctx) throws JobExecutionException {
        log.debug((Object)("executing job: " + new Date()));
        NavigationUtil.initBySql();
    }

    private static void initBySP() {
        ArrayList<QueryParam> plist = new ArrayList<QueryParam>();
        plist.add(new NamedQueryParam(GROUPID, 19));
        try {
            HibernateGenericsDAO dao = new HibernateGenericsDAO(NavigationItem.class);
            NAV_ITEMS = dao.findByNamedQuery(NAMED_QUERY, plist);
            log.debug((Object)("Number of Navigation Items to display from Liferay:" + NAV_ITEMS.size()));
            for (int i = 0; i < NAV_ITEMS.size(); ++i) {
                NavigationItem nav = NAV_ITEMS.get(i);
                if (nav.getLevelNumber() != 1) continue;
                TOP_NAV_ITEMS.add(nav);
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception caught: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initBySql() {
        log.debug((Object)"Load NavigationItem");
        try {
            HibernateGenericsDAO dao = new HibernateGenericsDAO(NavigationItem.class);
            TOP_NAV_ITEMS_TEMP.clear();
            NAV_ITEMS_TEMP.clear();
            NAVITEM_MAP_TEMP.clear();
            NAV_ITEMS_TEMP = dao.find(NAV_QUERY);
            log.debug((Object)("Number of Navigation Items to display from Liferay:" + NAV_ITEMS_TEMP.size()));
            String pname = "";
            ArrayList<NavigationItem> navList = null;
            for (int i = 0; i < NAV_ITEMS_TEMP.size(); ++i) {
                NavigationItem nav = NAV_ITEMS_TEMP.get(i);
                pname = nav.getParentName();
                navList = NAVITEM_MAP_TEMP.get(pname);
                if (navList == null) {
                    navList = new ArrayList();
                }
                navList.add(nav);
                NAVITEM_MAP_TEMP.put(pname, navList);
                if (nav.getLevelNumber() != 1) continue;
                TOP_NAV_ITEMS_TEMP.add(nav);
            }
        }
        catch (Exception e) {
            TOP_NAV_ITEMS_TEMP.clear();
            NAV_ITEMS_TEMP.clear();
            NAVITEM_MAP_TEMP.clear();
            TOP_NAV_ITEMS_TEMP.addAll(TOP_NAV_ITEMS);
            NAV_ITEMS_TEMP.addAll(NAV_ITEMS);
            NAVITEM_MAP_TEMP.putAll(NAVITEM_MAP);
            log.error((Object)("Exception caught: " + e.getMessage()));
        }
        finally {
            if (TOP_NAV_ITEMS_TEMP.size() > 0) {
                TOP_NAV_ITEMS.clear();
                TOP_NAV_ITEMS.addAll(TOP_NAV_ITEMS_TEMP);
            }
            if (NAV_ITEMS_TEMP.size() > 0) {
                NAV_ITEMS.clear();
                NAV_ITEMS.addAll(NAV_ITEMS_TEMP);
            }
            if (NAVITEM_MAP_TEMP.size() > 0) {
                NAVITEM_MAP.clear();
                NAVITEM_MAP.putAll(NAVITEM_MAP_TEMP);
            }
        }
    }

    public static List<NavigationItem> getAllNavItems() {
        return NAV_ITEMS;
    }

    public static List<NavigationItem> getTopNavItems() {
        return TOP_NAV_ITEMS;
    }

    public static List<NavigationItem> getNavItemsByParent(String parentKey) {
        return NAVITEM_MAP.get(parentKey);
    }

    public static Map<String, ArrayList<NavigationItem>> getNavItemMap() {
        return NAVITEM_MAP;
    }

    public static void main(String[] args) {
        NavigationUtil navigationUtil = new NavigationUtil();
    }

    static {
        NavigationUtil.initBySql();
        NavigationUtil.initScheduler();
    }
}

