/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MapUtil {
    private static final transient Logger log = Logger.getLogger((String)MapUtil.class.getName());

    private MapUtil() {
    }

    public static String getKeyByValue(Map<String, String> m, String value) {
        if (m == null || m.isEmpty()) {
            log.warn((Object)"map is null/empty");
            return null;
        }
        if (StringUtils.isBlank((String)value)) {
            log.warn((Object)"value is blank");
            return null;
        }
        try {
            Set<Map.Entry<String, String>> entries = m.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                if (!value.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception caught: " + e.getClass().getName()));
            return null;
        }
        return null;
    }

    public static List<String> getKeysByValues(Map<String, String> m, List<String> values) {
        if (m == null || m.isEmpty()) {
            log.warn((Object)"map is null/empty");
            return null;
        }
        if (values == null || values.isEmpty()) {
            log.warn((Object)"value list is null/empty");
            return null;
        }
        ArrayList<String> keys = new ArrayList<String>();
        try {
            Set<Map.Entry<String, String>> entries = m.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                if (!values.contains(entry.getValue())) continue;
                keys.add(entry.getKey());
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception caught: " + e.getMessage()));
        }
        return keys;
    }

    public static List<String> getValuesByKeys(Map<String, String> m, List<String> keys) {
        if (m == null || m.isEmpty()) {
            log.warn((Object)"map is null/empty");
            return null;
        }
        if (keys == null || keys.isEmpty()) {
            log.warn((Object)"key list is null/empty");
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        try {
            String value = null;
            for (String key : keys) {
                value = m.get(key);
                if (!StringUtils.isNotBlank((String)value)) continue;
                values.add(value);
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception caught: " + e.getMessage()));
        }
        return values;
    }

    public static String getStrValueIgnoreCase(Map<String, String> m, String key) {
        Set<Map.Entry<String, String>> entries = m.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            if (!key.equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void main(String[] args) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        m.put("4", "four");
        ArrayList<String> vList = new ArrayList<String>();
        vList.add("two");
        vList.add("four");
        System.out.println("keys: " + MapUtil.getKeysByValues(m, vList));
        ArrayList<String> kList = new ArrayList<String>();
        kList.add("1");
        kList.add("3");
        System.out.println("values: " + MapUtil.getValuesByKeys(m, kList));
    }
}

