/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public final class JarResources {
    private static final Logger log = Logger.getLogger((String)JarResources.class.getName());
    private Hashtable<String, Integer> htSizes = new Hashtable();
    private Hashtable<String, byte[]> htJarContents = new Hashtable();
    private String jarFileName;

    public JarResources(String jarFileName) {
        this.jarFileName = jarFileName;
        this.init();
    }

    public byte[] getResource(String name) {
        return this.htJarContents.get(name);
    }

    private void init() {
        try {
            ZipFile zf = new ZipFile(this.jarFileName);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                log.debug((Object)this.dumpZipEntry(ze));
                this.htSizes.put(ze.getName(), new Integer((int)ze.getSize()));
            }
            zf.close();
            FileInputStream fis = new FileInputStream(this.jarFileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.isDirectory()) continue;
                log.debug((Object)("ze.getName()=" + ze.getName() + ",getSize()=" + ze.getSize()));
                int size = (int)ze.getSize();
                if (size == -1) {
                    size = this.htSizes.get(ze.getName());
                }
                byte[] b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0 && (chunk = zis.read(b, rb, size - rb)) != -1) {
                    rb += chunk;
                }
                this.htJarContents.put(ze.getName(), b);
                log.debug((Object)(ze.getName() + "  rb=" + rb + ",size=" + size + ",csize=" + ze.getCompressedSize()));
            }
        }
        catch (NullPointerException e) {
            log.info((Object)"done.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String dumpZipEntry(ZipEntry ze) {
        StringBuffer sb = new StringBuffer();
        if (ze.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("defalted ");
        }
        sb.append(ze.getName());
        sb.append("\t");
        sb.append("" + ze.getSize());
        if (ze.getMethod() == 8) {
            sb.append("/" + ze.getCompressedSize());
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        JarResources jr;
        byte[] buff;
        if (args.length != 2) {
            log.error((Object)"usage: java JarResources <jar file name> <resource name>");
            System.exit(1);
        }
        if ((buff = (jr = new JarResources(args[0])).getResource(args[1])) == null) {
            log.debug((Object)("Could not find " + args[1] + "."));
        } else {
            log.debug((Object)("Found " + args[1] + " (length=" + buff.length + ")."));
        }
    }
}

