/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class IOUtil {
    private static final Logger log = Logger.getLogger((String)IOUtil.class.getName());
    private static final int BUF_SIZE = 1024;

    public static byte[] getBytes(InputStream is) throws IOException {
        if (is == null) {
            log.warn((Object)"InputStream is null - returning null");
            return null;
        }
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            IOUtil.streamCopy(is, bos);
            is.close();
            log.info((Object)"InputStream copied to OutputStream successfully");
            byte[] bytes = bos.toByteArray();
            log.debug((Object)("returning bytes.length=" + bytes.length));
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException e) {
            log.info((Object)"InputStream could not be copied to OutputStream");
            throw e;
        }
        finally {
            if (bos != null) {
                log.info((Object)"Closing output stream");
                bos.close();
            }
        }
    }

    public static void streamCopy(InputStream in, OutputStream out) throws IOException {
        byte[] buff = new byte[4096];
        int numCharRead = in.read(buff);
        while (numCharRead != -1) {
            out.write(buff, 0, numCharRead);
            numCharRead = in.read(buff);
        }
    }

    public static InputStream getInputStream(byte[] array) throws IOException {
        if (array == null) {
            throw new IOException(" Byte array cannot be null ");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(array);
        bais.read(array);
        return bais;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pipe(OutputStream out, InputStream in) throws IOException {
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        try {
            while ((bytesRead = in.read(buffer, 0, 1024)) >= 0) {
                out.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                out.flush();
            }
            catch (IOException iOException) {}
        }
    }
}

