/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.test.BaseTest;
import gov.grants.commons.util.HexDecimalConverter;
import gov.grants.commons.util.Timer;
import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HexDecimalConverterTest
extends BaseTest {
    private static final Logger log = Logger.getLogger((String)HexDecimalConverterTest.class.getName());
    private String hex = "4BAA11AF";
    private BigInteger decimal = new BigInteger("1269436847");
    private Timer timer;

    @Before
    public void setUp() {
        this.timer = new Timer();
        this.timer.start();
    }

    @After
    public void tearDown() throws Exception {
        log.debug((Object)"--- tearDown()");
        this.timer.stop();
        log.debug((Object)("elapsed time(ms): " + this.timer.toMillisecondsLong()));
    }

    @Test
    public void hexToDecimal() {
        log.debug((Object)("--- converting hex=" + this.hex));
        BigInteger decimalValue = HexDecimalConverter.hexToDecimal(this.hex);
        log.debug((Object)("--- decimal value=" + decimalValue));
        Assert.assertEquals((Object)this.decimal, (Object)decimalValue);
    }

    @Test
    public void decimalToHex() {
        log.debug((Object)("--- converting decimal=" + this.decimal));
        String hexValue = HexDecimalConverter.decimalToHex(this.decimal);
        log.debug((Object)("--- hex value=" + hexValue));
        Assert.assertEquals((String)this.hex, (Object)this.hex.toUpperCase(), (Object)hexValue);
    }
}

