/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import org.apache.log4j.Logger;

public class HexDecimalConverter {
    private static final Logger log = Logger.getLogger((String)HexDecimalConverter.class.getName());

    public static BigInteger hexToDecimal(String hex) {
        log.debug((Object)("Hex=" + hex));
        hex = hex.replaceAll(" ", "");
        log.debug((Object)("Updated hex=" + hex));
        String digits = "0123456789ABCDEF";
        hex = hex.toUpperCase();
        BigInteger decimal = BigInteger.valueOf(0L);
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            int index = digits.indexOf(c);
            decimal = decimal.multiply(BigInteger.valueOf(16L)).add(BigInteger.valueOf(index));
        }
        log.debug((Object)("--- Returning decimal value=" + decimal));
        return decimal;
    }

    public static String decimalToHex(BigInteger decimal) {
        String digits = "0123456789ABCDEF";
        if (decimal.intValue() == 0) {
            return "0";
        }
        String hex = "";
        BigInteger digit = BigInteger.valueOf(0L);
        while (decimal.compareTo(BigInteger.valueOf(0L)) == 1) {
            digit = decimal.mod(BigInteger.valueOf(16L));
            hex = digits.charAt(digit.intValue()) + hex;
            decimal = decimal.divide(BigInteger.valueOf(16L));
        }
        log.debug((Object)("--- Returning hex value=" + hex));
        return hex;
    }

    static int getHexValue(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }

    public static void main(String[] args) {
        String hex = null;
        if (args.length == 0) {
            System.out.print("Enter a Hexadecimal Number: ");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            try {
                hex = br.readLine().replaceAll(" ", "");
            }
            catch (IOException ioe) {
                System.out.println("IO error trying to read hex value.");
                System.exit(1);
            }
        } else {
            hex = args[0].replaceAll(" ", "");
        }
        System.out.println("Hex Value: " + hex);
        BigInteger dec = BigInteger.valueOf(0L);
        for (int i = 0; i < hex.length(); ++i) {
            int digit = HexDecimalConverter.getHexValue(hex.charAt(i));
            if (digit == -1) {
                System.out.println("Error: Input is not a hexadecimal number.");
                return;
            }
            dec = dec.multiply(BigInteger.valueOf(16L)).add(BigInteger.valueOf(digit));
        }
        System.out.println("Dec Value: " + dec);
    }
}

