/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class GGStringUtils {
    private static final Logger log = Logger.getLogger((String)GGStringUtils.class.getName());

    public static String padWithZeros(String str, int size) {
        StringBuffer buf = new StringBuffer();
        str = str.trim();
        for (int i = 0; i < size - str.length(); ++i) {
            buf.append("0");
        }
        buf.append(str);
        return buf.toString();
    }

    public static String stripChars(String str, char token) {
        StringBuffer newString = new StringBuffer();
        StringTokenizer st = new StringTokenizer(str, new StringBuffer(token).append(token).toString());
        while (st.hasMoreTokens()) {
            newString.append(st.nextToken());
        }
        return newString.toString();
    }

    public static String padDuns(String duns) {
        if (duns != null && duns.length() == 9) {
            duns = duns + "0000";
        }
        return duns;
    }

    public static String removeCharFromString(String value, char removeChar) {
        if (value == null || value.equals("")) {
            return value;
        }
        StringBuffer retVal = new StringBuffer();
        char[] removeArray = new char[]{removeChar};
        StringTokenizer st = new StringTokenizer(value, new String(removeArray));
        while (st.hasMoreTokens()) {
            retVal.append(st.nextToken());
        }
        return retVal.toString();
    }

    public static String getStackTraceAsStr(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.print(" [ ");
        pw.print(t.getClass().getName());
        pw.print(" ] ");
        pw.print(t.getMessage());
        pw.print("\n");
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    public static String stripUserIdPrefix(String prefixedUserId) {
        return prefixedUserId == null ? null : prefixedUserId.replaceFirst("^GG-|^ORC-", "");
    }

    public static String getHtmlList(String[] list) {
        String output = "<ul>";
        for (String str : list) {
            output = output + "<li>" + str.trim() + "</li>\n";
        }
        return output + "</ul>";
    }

    public static String getHtmlList(String listStr) {
        String output = "";
        if (listStr != null) {
            String[] list = listStr.split(",");
            output = GGStringUtils.getHtmlList(list);
        }
        return output;
    }
}

