/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GDGMathUtil {
    private static final Logger log = Logger.getLogger((String)GDGMathUtil.class.getName());
    private static final String DEFAULT_DISPLAY_VALUE = "---";

    public static String getFileSizeDisplay(Long fileSize, String defaultValue) {
        String displayValue;
        String string = displayValue = StringUtils.isBlank((String)defaultValue) ? DEFAULT_DISPLAY_VALUE : defaultValue;
        if (fileSize == null) {
            return displayValue;
        }
        try {
            long kb = 1024L;
            long mb = 0x100000L;
            BigDecimal size = null;
            if (fileSize >= mb) {
                size = BigDecimal.valueOf(fileSize).divide(BigDecimal.valueOf(mb), 1, RoundingMode.HALF_UP);
                return size + " MB";
            }
            if (fileSize >= kb) {
                size = BigDecimal.valueOf(fileSize).divide(BigDecimal.valueOf(kb), 1, RoundingMode.HALF_UP);
                return size + " KB";
            }
            return fileSize + " B";
        }
        catch (Exception e) {
            log.error((Object)e);
            return displayValue;
        }
    }
}

