/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.test.BaseTest;
import gov.grants.commons.util.GDGEscapeUtil;
import gov.grants.commons.util.Timer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GDGEscapeUtilTest
extends BaseTest {
    private static final Logger log = Logger.getLogger((String)GDGEscapeUtilTest.class.getName());
    private Timer timer;

    @Before
    public void setUp() {
        this.timer = new Timer();
        this.timer.start();
    }

    @After
    public void tearDown() throws Exception {
        log.debug((Object)"--- tearDown()");
        this.timer.stop();
        log.debug((Object)("elapsed time(ms): " + this.timer.toMillisecondsLong()));
    }

    @Test
    public void removeEnclosingDoubleQuotes() {
        String s = null;
        String modStr = null;
        log.debug((Object)("--- modifying: " + s));
        modStr = GDGEscapeUtil.removeEnclosingDoubleQuotes(s);
        log.debug((Object)("--- mod str: " + modStr));
        Assert.assertNull((String)"null", (Object)modStr);
        s = "";
        log.debug((Object)("--- modifying: " + s));
        modStr = GDGEscapeUtil.removeEnclosingDoubleQuotes(s);
        log.debug((Object)("--- mod str: " + modStr));
        Assert.assertEquals((Object)"", (Object)modStr);
        s = "my string without extra quotes";
        log.debug((Object)("--- modifying: " + s));
        modStr = GDGEscapeUtil.removeEnclosingDoubleQuotes(s);
        log.debug((Object)("--- mod str: " + modStr));
        Assert.assertEquals((Object)"my string without extra quotes", (Object)modStr);
        s = "\"my string with extra quotes\"";
        log.debug((Object)("--- modifying: " + s));
        modStr = GDGEscapeUtil.removeEnclosingDoubleQuotes(s);
        log.debug((Object)("--- mod str: " + modStr));
        Assert.assertEquals((Object)"my string with extra quotes", (Object)modStr);
    }

    @Test
    public void replaceEnclosingSingleQuotes() {
        String s = null;
        String modStr = null;
        log.debug((Object)("--- modifying: " + s));
        modStr = GDGEscapeUtil.replaceEnclosingSingleQuotes(s);
        log.debug((Object)("--- mod str: " + modStr));
        Assert.assertNull((String)"null", (Object)modStr);
        s = "";
        log.debug((Object)("--- modifying: " + s));
        modStr = GDGEscapeUtil.replaceEnclosingSingleQuotes(s);
        log.debug((Object)("--- mod str: " + modStr));
        Assert.assertEquals((Object)"", (Object)modStr);
        s = "'my string enclosed in single quotes'";
        log.debug((Object)("--- modifying: " + s));
        modStr = GDGEscapeUtil.replaceEnclosingSingleQuotes(s);
        log.debug((Object)("--- mod str: " + modStr));
        Assert.assertEquals((Object)"\"my string enclosed in single quotes\"", (Object)modStr);
        s = "'my string - left single - right double\"";
        log.debug((Object)("--- modifying: " + s));
        modStr = GDGEscapeUtil.replaceEnclosingSingleQuotes(s);
        log.debug((Object)("--- mod str: " + modStr));
        Assert.assertEquals((Object)"\"my string - left single - right double\"", (Object)modStr);
        s = "\"my string - right single - left double'";
        log.debug((Object)("--- modifying: " + s));
        modStr = GDGEscapeUtil.replaceEnclosingSingleQuotes(s);
        log.debug((Object)("--- mod str: " + modStr));
        Assert.assertEquals((Object)"\"my string - right single - left double\"", (Object)modStr);
        s = "my string - 'middle single";
        log.debug((Object)("--- modifying: " + s));
        modStr = GDGEscapeUtil.replaceEnclosingSingleQuotes(s);
        log.debug((Object)("--- mod str: " + modStr));
        Assert.assertEquals((Object)"my string - 'middle single", (Object)modStr);
    }
}

