/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class GDGEscapeUtil {
    private static final Logger log = Logger.getLogger((String)GDGEscapeUtil.class.getName());
    private static final Pattern NONASCII_PATTERN;
    private static final Perl5Substitution EMPTY_STR_SUB;

    private GDGEscapeUtil() {
    }

    public static String removeEnclosingDoubleQuotes(String s) {
        String modStr = null;
        if (StringUtils.isBlank((String)s)) {
            log.warn((Object)"String is blank");
            return s;
        }
        modStr = s.replaceAll("(\\A\")|(\"\\z)", "");
        log.debug((Object)(s + " modified: " + modStr));
        return modStr;
    }

    public static String replaceEnclosingSingleQuotes(String s) {
        String modStr = null;
        if (StringUtils.isBlank((String)s)) {
            log.warn((Object)"String is blank");
            return s;
        }
        modStr = s.replaceAll("(\\A')|('\\z)", "\"");
        log.debug((Object)(s + " modified: " + modStr));
        return modStr;
    }

    public static String encodeSpecialChars(String s) {
        String modStr = null;
        if (StringUtils.isBlank((String)s)) {
            log.warn((Object)"String is blank");
            return s;
        }
        modStr = s;
        modStr = modStr.replaceAll("&", "%26");
        modStr = modStr.replaceAll("\\+", "%2B");
        log.debug((Object)(s + " modified: " + modStr));
        return modStr;
    }

    public static String replaceEncodedNonPrintableChars(String text, String replacement) {
        String regex = null;
        regex = "#[0-9]+;";
        regex = "#([0-9]|[1-2][0-9]|3[0-1]);";
        try {
            log.debug((Object)("original text: " + text));
            String updatedText = text.replaceAll(regex, replacement);
            log.debug((Object)("updated text: " + updatedText));
            return updatedText;
        }
        catch (Exception e) {
            log.error((Object)e);
            log.info((Object)"returning original text");
            return text;
        }
    }

    public static String replaceNonPrintableChars(String s, String replacement) {
        String regex = null;
        regex = "[\\x00-\\x1F]";
        try {
            log.debug((Object)("original text: " + s));
            String updatedText = s.replaceAll(regex, replacement);
            log.debug((Object)("updated text: " + updatedText));
            return updatedText;
        }
        catch (Exception e) {
            log.error((Object)e);
            log.info((Object)"returning original text");
            return s;
        }
    }

    public static String replaceNonAsciiChars(String text, String replacement) {
        if (StringUtils.isEmpty((String)text)) {
            return text;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        String cleanText = "";
        cleanText = Util.substitute((PatternMatcher)matcher, (Pattern)NONASCII_PATTERN, (Substitution)new Perl5Substitution(replacement), (String)StringEscapeUtils.escapeXml((String)text), (int)-1);
        cleanText = StringEscapeUtils.unescapeXml((String)cleanText);
        try {
            return new String(cleanText.getBytes("UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage());
            log.debug((Object)("returning: " + cleanText));
            return cleanText;
        }
    }

    public static String urlEncodeReservedUrlEncodeChars(String s) {
        String percentSignRegex = "%(?![0-9a-fA-F]{2})";
        String percentSignEncode = "%25";
        String plusSignRegex = "\\+";
        String plusSignEncode = "%2B";
        String updatedText = null;
        try {
            log.debug((Object)("original text: " + s));
            updatedText = s.replaceAll(percentSignRegex, percentSignEncode);
            log.debug((Object)("replaced percent sign: " + updatedText));
            updatedText = updatedText.replaceAll(plusSignRegex, plusSignEncode);
            log.debug((Object)("replaced plus sign: " + updatedText));
            return updatedText;
        }
        catch (Exception e) {
            log.error((Object)e);
            log.info((Object)"returning original text");
            return s;
        }
    }

    static {
        EMPTY_STR_SUB = new Perl5Substitution(" ");
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            NONASCII_PATTERN = compiler.compile("[^a-zA-Z0-9 !@#$%\\^&*()_+=\\-,\\./';\\[\\]\\\\|}{\":?><~`]");
        }
        catch (MalformedPatternException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

