/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.test.BaseTest;
import gov.grants.commons.util.FormatUtil;
import gov.grants.commons.util.Timer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FormatUtilTest
extends BaseTest {
    private static final Logger log = Logger.getLogger((String)FormatUtilTest.class.getName());
    private Timer timer;

    @Before
    public void setUp() {
        this.timer = new Timer();
        this.timer.start();
    }

    @After
    public void tearDown() throws Exception {
        log.debug((Object)"--- tearDown()");
        this.timer.stop();
        log.debug((Object)("elapsed time(ms): " + this.timer.toMillisecondsLong()));
    }

    @Test
    public void addCommas() {
        String s = "";
        String value = "";
        s = "1234567890";
        log.debug((Object)("--- formatting: " + s));
        value = FormatUtil.addCommas(s);
        log.debug((Object)("--- formatted str: " + value));
        Assert.assertEquals((Object)"1,234,567,890", (Object)value);
        s = "123";
        log.debug((Object)("--- formatting: " + s));
        value = FormatUtil.addCommas(s);
        log.debug((Object)("--- formatted str: " + value));
        Assert.assertEquals((Object)"123", (Object)value);
        s = "abc";
        log.debug((Object)("--- formatting: " + s));
        value = FormatUtil.addCommas(s);
        log.debug((Object)("--- formatted str: " + value));
        Assert.assertNull((Object)value);
        s = null;
        log.debug((Object)("--- formatting: " + s));
        value = FormatUtil.addCommas(s);
        log.debug((Object)("--- formatted str: " + value));
        Assert.assertNull((Object)value);
    }
}

