/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.util.RegexUtil;
import java.text.DecimalFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FormatUtil {
    private static final Logger log = Logger.getLogger((String)FormatUtil.class.getName());

    public static String addCommas(String numberStr) {
        if (StringUtils.isBlank((String)numberStr)) {
            log.debug((Object)"number string is blank -- returning null");
            return null;
        }
        try {
            String pattern = "#,###";
            DecimalFormat formatter = new DecimalFormat(pattern);
            String formattedStr = formatter.format(Long.parseLong(numberStr));
            return formattedStr;
        }
        catch (Exception e) {
            log.error((Object)("Exception formatting number string[" + numberStr + "]: " + e.getMessage()));
            return null;
        }
    }

    public static boolean isValidPhoneNumberUS(String phoneNumber) {
        return StringUtils.isNotBlank((String)phoneNumber) && RegexUtil.matches("^\\(?([0-9]{3})\\)?[-\\s]?([0-9]{3})[-\\s]?([0-9]{4})$", phoneNumber);
    }

    public static String changeEmailStringtoHiddenFormat(String plainEmailAddress) {
        if (StringUtils.isBlank((String)plainEmailAddress)) {
            log.debug((Object)"PlainEmailAddress string is blank -- returning null");
            return null;
        }
        if (!StringUtils.contains((String)plainEmailAddress, (String)"@")) {
            log.debug((Object)"string not containing @ so not proper email address -- returning null");
            return null;
        }
        try {
            StringBuffer appendingString = new StringBuffer();
            String firstEmailString = "";
            String remainingString = "";
            String[] splitEmailAddress = plainEmailAddress.split("@");
            firstEmailString = splitEmailAddress[0];
            remainingString = splitEmailAddress[1];
            int reducedLength = splitEmailAddress[0].length();
            log.debug((Object)("Split Email Id by @:" + firstEmailString + "===" + remainingString));
            for (int i = 0; i < reducedLength; ++i) {
                if (i == 0 || i == reducedLength - 1) {
                    appendingString.append(firstEmailString.charAt(i));
                    continue;
                }
                appendingString.append("*");
            }
            log.debug((Object)("Hidden Format Email:" + appendingString.toString() + "@" + remainingString));
            return appendingString.toString() + "@" + remainingString;
        }
        catch (Exception e) {
            log.error((Object)("Exception formatting email Address string[" + plainEmailAddress + "]: " + e.getMessage()));
            return null;
        }
    }

    public static String changeMobileNumbertoHiddenFormat(String mobilePhoneNumber) {
        if (StringUtils.isBlank((String)mobilePhoneNumber)) {
            log.debug((Object)"mobilePhoneNumber string is blank -- returning null");
            return null;
        }
        if (mobilePhoneNumber.length() > 10 || mobilePhoneNumber.length() < 10) {
            log.debug((Object)"mobilePhoneNumber String Length not valid");
            return null;
        }
        try {
            StringBuffer appendingString = new StringBuffer();
            int plainMobileNumberLength = mobilePhoneNumber.length();
            int shortLength = 6;
            String lastString = "";
            lastString = mobilePhoneNumber.substring(plainMobileNumberLength - 4, plainMobileNumberLength);
            for (int i = 0; i < shortLength; ++i) {
                appendingString.append("*");
            }
            log.debug((Object)(" -- Append string mobilenumber--" + appendingString.toString() + lastString));
            return appendingString.toString() + lastString;
        }
        catch (Exception e) {
            log.error((Object)("Exception formatting email Address string[" + mobilePhoneNumber + "]: " + e.getMessage()));
            return null;
        }
    }
}

