/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.util.IOUtil;
import gov.grants.commons.util.RandomUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger log = Logger.getLogger((String)FileUtil.class.getName());
    private static final int BUF_SIZE = 1024;

    public static String[] getFileNames(String path) throws IOException {
        log.info((Object)"In getFileNames method");
        if (path == null) {
            throw new IOException("Path cannot be null");
        }
        File src = new File(path);
        return src.list();
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        log.info((Object)"load file bytes from disk");
        String errorMsg = null;
        if (file == null) {
            errorMsg = "File object is null -- cannot get bytes from file";
            log.error((Object)errorMsg);
            throw new IOException(errorMsg);
        }
        log.info((Object)(file.getPath() + " exists: " + file.exists()));
        if (!file.exists()) {
            errorMsg = file.getPath() + " does not exist";
            log.error((Object)errorMsg);
            throw new IOException(errorMsg);
        }
        InputStream is = null;
        byte[] bytes = null;
        try {
            long fileSize = file.length();
            log.info((Object)("file size: " + fileSize));
            is = new FileInputStream(file);
            bytes = IOUtils.toByteArray((InputStream)is);
            long bytesLength = bytes.length;
            log.info((Object)("file bytes loaded: " + bytesLength));
            if (bytesLength > Integer.MAX_VALUE) {
                log.error((Object)"File size is too large -- larger than Integer.MAX_VALUE [2147483647].");
                throw new IOException("File size is too large -- larger than Integer.MAX_VALUE [2147483647].");
            }
            if (bytesLength < fileSize) {
                log.debug((Object)("Could not completely read file:" + file.getName()));
                throw new IOException("Could not completely read file:" + file.getName());
            }
        }
        catch (IOException e) {
            log.debug((Object)("IOException caught:\n" + e.getMessage()));
            throw e;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                log.debug((Object)("IOException caught closing InputStream:\n" + e.getMessage()));
            }
        }
        return bytes;
    }

    public static byte[] readFile(String path) throws IOException {
        if (StringUtils.isBlank((String)path)) {
            log.error((Object)"Cannot create File instance -- 'path' is null or empty");
            return null;
        }
        File file = new File(path);
        return FileUtil.getBytesFromFile(file);
    }

    public static byte[] readFile(String dir, String filename) throws IOException {
        if (StringUtils.isBlank((String)dir) || StringUtils.isBlank((String)filename)) {
            log.error((Object)"Cannot create File instance -- 'path' is null or empty");
            return null;
        }
        File file = new File(dir, filename);
        return FileUtil.getBytesFromFile(file);
    }

    public static void bytesToDisk(byte[] outBytes, String sRealPath) throws IOException {
        log.info((Object)"In bytesToDisk method");
        if (outBytes == null) {
            throw new IOException("Byte array cannot be null");
        }
        if (sRealPath == null || "".equals(sRealPath)) {
            throw new IOException("path cannot be null or blank");
        }
        FileOutputStream oNewFile = new FileOutputStream(sRealPath);
        oNewFile.write(outBytes);
        oNewFile.close();
    }

    public static void bytesToDisk(byte[] outBytes, File sRealPath) throws IOException {
        log.info((Object)"In bytesToDisk method");
        if (outBytes == null) {
            throw new IOException(" Byte array cannot be null ");
        }
        if (sRealPath == null) {
            throw new IOException(" File path cannot be null ");
        }
        FileOutputStream oNewFile = new FileOutputStream(sRealPath);
        oNewFile.write(outBytes);
        oNewFile.close();
    }

    public static String readFileAsString(String filePath) throws IOException {
        log.info((Object)"In readFileAsString method");
        if (StringUtils.isBlank((String)filePath)) {
            throw new IOException("File path cannot be null or blank");
        }
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        if (reader != null) {
            reader.close();
        }
        return fileData.toString();
    }

    public static byte[] getBytes(InputStream in) throws IOException {
        log.info((Object)"Get byte[] from InputStream");
        String errorMsg = null;
        if (in == null) {
            errorMsg = "Input Stream is null -- cannot get byte[] from InputStream";
            log.error((Object)errorMsg);
            throw new IOException(errorMsg);
        }
        byte[] fileBytes = IOUtils.toByteArray((InputStream)in);
        log.info((Object)("file bytes size: " + fileBytes.length));
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileBytes;
    }

    public static String replaceBackSlashWithForwardSlash(String string) {
        log.info((Object)"In replaceBackSlashWithForwardSlash method");
        return string.replaceAll("\\\\", "/");
    }

    public static void checkDirectory(String receiptTempDir) throws IOException {
        File tempDir = new File(receiptTempDir);
        if (!tempDir.exists()) {
            throw new IOException("Temporary Directory for storing sumissions at \"" + receiptTempDir + "\" does not exist.");
        }
        if (!tempDir.canWrite()) {
            throw new IOException("Temporary Directory for storing sumissions at \"" + receiptTempDir + "\" can not be written to.");
        }
    }

    public static boolean deleteDir(File dir) {
        FileUtil.removeAllFiles(dir);
        return dir.delete();
    }

    public static void removeAllFiles(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                FileUtil.removeAllFiles(f);
            }
            f.delete();
        }
    }

    public static void cleanDirectory(File dir, boolean keepSubDirs) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                if (keepSubDirs) continue;
                FileUtil.cleanDirectory(f, false);
                f.delete();
                continue;
            }
            f.delete();
        }
    }

    void cleanDirectoryButKeepSubDirectories(File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) continue;
            file.delete();
        }
    }

    public static String formPath(String parent, String child) {
        if (parent.endsWith(File.separator)) {
            return parent + child;
        }
        return parent + File.separator + child;
    }

    public static File findFileWithExt(File searchDir, String ext) throws FileNotFoundException {
        return FileUtil.findFilesWithExt(searchDir, ext)[0];
    }

    public static File[] findFilesWithExt(final File searchDir, final String ext) throws FileNotFoundException {
        File[] files = searchDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return searchDir.equals(dir) && name.endsWith(ext);
            }
        });
        if (files != null && files.length > 0) {
            return files;
        }
        throw new FileNotFoundException("Could not find file ending with " + ext);
    }

    public static File[] findFilesWithExt(final File searchDir, final String ext, final String exclusionExt) throws FileNotFoundException {
        File[] files = searchDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return searchDir.equals(dir) && name.endsWith(ext) && !name.endsWith(exclusionExt);
            }
        });
        if (files != null && files.length > 0) {
            return files;
        }
        throw new FileNotFoundException("Could not find file ending with " + ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileIntoString(String path) throws FileNotFoundException, IOException {
        BufferedReader in = null;
        StringBuffer result = new StringBuffer();
        int charsRead = 0;
        char[] buf = new char[1024];
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
            while ((charsRead = in.read(buf, 0, 1024)) > 0) {
                result.append(buf, 0, charsRead);
            }
            String string = result.toString();
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readToFile(String outFilePath, InputStream input) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outFilePath);
            IOUtil.pipe(out, input);
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeToFile(String filename, String content) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes("UTF-8"));
        FileUtil.readToFile(filename, input);
    }

    public static void writeToFile(String filename, InputStream in) throws IOException {
        if (StringUtils.isBlank((String)filename)) {
            log.error((Object)"Output filename is blank");
            throw new IOException("Output filename is blank");
        }
        log.debug((Object)("Create output stream for filename=" + filename));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(filename));
        log.debug((Object)"Send to IOUtil to write to file");
        IOUtil.pipe(out, in);
        log.debug((Object)"Successfully written to file");
    }

    public static final void copy(String from, String to) throws IOException {
        FileUtil.copy(new File(from), new File(to));
    }

    public static final void copy(File from, File to) throws IOException {
        IOUtil.pipe(new BufferedOutputStream(new FileOutputStream(to)), new BufferedInputStream(new FileInputStream(from)));
    }

    public static final void move(String from, String to) throws IOException {
        FileUtil.copy(from, to);
        new File(from).delete();
    }

    public static final void move(File from, File to) throws IOException {
        FileUtil.copy(from, to);
        from.delete();
    }

    public static boolean saveProperties(Properties props, String filePath, String propertyListDesc) throws Exception {
        log.info((Object)("Save properties to file system: " + props));
        if (props == null || props.isEmpty()) {
            throw new Exception("Properties is empty -- cannot save properties");
        }
        if (StringUtils.isBlank((String)filePath)) {
            throw new Exception("Properties file path is blank -- cannot save properties");
        }
        if (StringUtils.isBlank((String)propertyListDesc)) {
            propertyListDesc = "PROPERTIES_" + String.valueOf(RandomUtil.getRandomInt());
        }
        File propsFile = new File(filePath);
        try {
            FileOutputStream fos = new FileOutputStream(propsFile);
            props.store(fos, propertyListDesc);
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)("Caught FileNotFoundException while attempting to create a FileOutputStream" + filePath));
            throw new Exception("Caught FileNotFoundException while attempting to create a FileOutputStream to  \"" + filePath + ". This could happen 'if the file exists but is a directory rather than a regular file, does not exist but cannot be created, or cannot be opened for any other reason'.", fnfe);
        }
        catch (IOException ioe) {
            log.error((Object)("Caught IOException while attempting to write submission metadata properties for " + filePath + "\"."));
            throw new Exception("Caught IOException while attempting to write submission metadata properties for " + filePath + "\".", ioe);
        }
        log.debug((Object)"Properties successfully saved");
        return true;
    }

    public static String addEndingFileSeparator(String directoryPath) {
        if (!directoryPath.endsWith(File.separator)) {
            return directoryPath + File.separator;
        }
        return directoryPath;
    }

    public static void writeByteArrayToFile(String outFilePath, byte[] bytes) {
        try {
            log.debug((Object)("write updated xml to disk: " + outFilePath));
            File outFile = new File(outFilePath);
            FileUtils.writeByteArrayToFile((File)outFile, (byte[])bytes);
            log.debug((Object)("bytes written successfully to file: " + outFile.getPath()));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public static String fixUtf8Filename(String filename) {
        String escapedFilename = "unknown";
        try {
            escapedFilename = URLEncoder.encode(filename, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
        }
        return escapedFilename;
    }
}

