/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.test.BaseTest;
import gov.grants.commons.util.DunsUtil;
import gov.grants.commons.util.Timer;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DunsUtilTest
extends BaseTest {
    private static final transient Logger log = Logger.getLogger((String)DunsUtilTest.class.getName());
    private Timer timer;

    @Before
    public void setUp() {
        this.timer = new Timer();
        this.timer.start();
    }

    @After
    public void tearDown() throws Exception {
        log.debug((Object)"--- tearDown()");
        this.timer.stop();
        log.debug((Object)("elapsed time(ms): " + this.timer.toMillisecondsLong()));
    }

    @Test
    public void getDuns13() {
        String duns = "123456789";
        Assert.assertEquals((String)"9-digit", (Object)"1234567890000", (Object)DunsUtil.getDuns13(duns));
        duns = "12345678900";
        Assert.assertEquals((String)"11-digit", (Object)"1234567890000", (Object)DunsUtil.getDuns13(duns));
        duns = "1234567890000";
        Assert.assertEquals((String)"13-digit", (Object)"1234567890000", (Object)DunsUtil.getDuns13(duns));
    }

    @Test
    public void getDuns9() {
        String duns = "123456789";
        Assert.assertEquals((String)"9-digit", (Object)"123456789", (Object)DunsUtil.getDuns9(duns));
        duns = "12345678900";
        Assert.assertEquals((String)"11-digit", (Object)"123456789", (Object)DunsUtil.getDuns9(duns));
        duns = "1234567890000";
        Assert.assertEquals((String)"13-digit", (Object)"123456789", (Object)DunsUtil.getDuns9(duns));
    }
}

