/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.GenericValidator;
import org.apache.log4j.Logger;

public class DunsUtil {
    private static final transient Logger LOG = Logger.getLogger((String)DunsUtil.class.getName());

    private DunsUtil() {
    }

    public static String getDuns13(String duns) {
        if (DunsUtil.isPotentialDuns(duns) && duns.length() < 13) {
            duns = StringUtils.rightPad((String)duns, (int)13, (String)"0");
        }
        return duns;
    }

    public static String getDunsPadded(String duns) {
        if (duns != null) {
            if (duns.length() == 9) {
                return duns;
            }
            if (duns.length() == 13) {
                return StringUtils.rightPad((String)StringUtils.left((String)duns, (int)9), (int)13, (String)"0");
            }
        }
        return "";
    }

    public static String getDuns9(String duns) {
        if (StringUtils.isNotBlank((String)duns) && duns.length() > 8) {
            duns = duns.substring(0, 9);
        }
        return duns;
    }

    public static String getPlus4(String duns, boolean pad) {
        String plus4 = "";
        if (StringUtils.isNotBlank((String)duns)) {
            int dunsLength = duns.length();
            if (pad) {
                if (dunsLength > 8 && dunsLength < 14) {
                    plus4 = StringUtils.leftPad((String)duns.substring(9), (int)4, (String)"0");
                }
            } else if (dunsLength == 13) {
                plus4 = duns.substring(9);
            } else if (dunsLength == 9) {
                plus4 = "0000";
            }
        }
        return plus4;
    }

    public static boolean isValidDUNSLength(String duns, int dunsLength) {
        if (StringUtils.isBlank((String)duns)) {
            LOG.error((Object)"DUNS is blank");
            return false;
        }
        if (duns.length() != dunsLength) {
            LOG.error((Object)("DUNS length is not " + dunsLength));
            return false;
        }
        return true;
    }

    public static boolean isValidPlus4Length(String plus4) {
        if (StringUtils.isBlank((String)plus4)) {
            LOG.error((Object)"DUNS plus 4 is blank");
            return false;
        }
        if (plus4.length() != 4) {
            LOG.error((Object)"DUNS plus 4 length is not 4");
            return false;
        }
        return true;
    }

    public static String getUeiDuns(String ueiDuns) {
        if (DunsUtil.isPotentialDuns(ueiDuns)) {
            return DunsUtil.getDuns13(ueiDuns);
        }
        return ueiDuns;
    }

    public static boolean isInvalidUeiDuns(String str) {
        return !DunsUtil.isPotentialUei(str) && !DunsUtil.isPotentialDuns(str);
    }

    public static boolean isPotentialUei(String str) {
        if (StringUtils.isBlank((String)str)) {
            return false;
        }
        return str.length() == 12;
    }

    public static boolean isPotentialDuns(String str) {
        if (StringUtils.isBlank((String)str)) {
            return false;
        }
        return GenericValidator.matchRegexp((String)str, (String)"^\\d{9}$|^\\d{9}[a-zA-Z0-9]{4}$");
    }

    public static boolean isDuns9(String str) {
        if (StringUtils.isBlank((String)str)) {
            return false;
        }
        return GenericValidator.matchRegexp((String)str, (String)"^\\d{9}$");
    }

    public static boolean isDuns13(String str) {
        if (StringUtils.isBlank((String)str)) {
            return false;
        }
        return GenericValidator.matchRegexp((String)str, (String)"^\\d{9}[a-zA-Z0-9]{4}$");
    }

    public static boolean isIndividualDuns(String duns) {
        return "000000000INDV".equalsIgnoreCase(duns);
    }

    public static boolean isIndividualUei(String uei) {
        return "00000000INDV".equalsIgnoreCase(uei);
    }

    public static boolean isIndividual(String ueiOrDuns) {
        return DunsUtil.isIndividualUei(ueiOrDuns) || DunsUtil.isIndividualDuns(ueiOrDuns);
    }

    public static boolean isThirdPartyDuns(String duns) {
        return "000000000TPSP".equalsIgnoreCase(duns);
    }

    public static boolean isThirdPartyUei(String uei) {
        return "00000000TPSP".equalsIgnoreCase(uei);
    }

    public static boolean isThirdParty(String ueiOrDuns) {
        return DunsUtil.isThirdPartyUei(ueiOrDuns) || DunsUtil.isThirdPartyDuns(ueiOrDuns);
    }

    public static boolean isStartWithDuns9(String str) {
        if (StringUtils.isBlank((String)str)) {
            return false;
        }
        return GenericValidator.matchRegexp((String)str, (String)"^\\d{9}.*");
    }
}

