/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.test.BaseTest;
import gov.grants.commons.util.DateUtil;
import gov.grants.commons.util.Timer;
import java.util.Date;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DateUtilTest
extends BaseTest {
    private static final Logger log = Logger.getLogger((String)DateUtilTest.class.getName());
    private Timer timer;

    @Before
    public void setUp() {
        this.timer = new Timer();
        this.timer.start();
    }

    @After
    public void tearDown() throws Exception {
        log.debug((Object)"--- tearDown()");
        this.timer.stop();
        log.debug((Object)("elapsed time(ms): " + this.timer.toMillisecondsLong()));
    }

    @Test
    public void stringToDate() {
        block11: {
            String dateStr = null;
            String dateStrFormat = null;
            Date date = null;
            String exceptionStr = null;
            try {
                dateStr = "04/01/2010 12:43:22";
                dateStrFormat = "MM/dd/yyyy HH:mm:ss";
                date = DateUtil.stringToDate(dateStr, dateStrFormat);
                log.debug((Object)("date: " + date + null));
                try {
                    date = DateUtil.stringToDate(null, dateStrFormat);
                }
                catch (Exception e) {
                    exceptionStr = "Date string is blank";
                    if (exceptionStr.equalsIgnoreCase(e.getMessage())) {
                        log.info((Object)"expected exception message");
                    }
                    Assert.fail((String)("Unexpected exception message: " + e.getMessage()));
                }
                try {
                    date = DateUtil.stringToDate(dateStr, null);
                }
                catch (Exception e) {
                    exceptionStr = "Date format string is blank";
                    if (exceptionStr.equalsIgnoreCase(e.getMessage())) {
                        log.info((Object)"expected exception message");
                    }
                    Assert.fail((String)("Unexpected exception message: " + e.getMessage()));
                }
                try {
                    dateStr = "04/01/2010 12:43:22";
                    dateStrFormat = "yyyyMMddHHmmss";
                    date = DateUtil.stringToDate(dateStr, dateStrFormat);
                    log.debug((Object)("bad formatted date: " + date));
                }
                catch (Exception e) {
                    exceptionStr = "Date string [" + dateStr + "] is not same length as the date format string [" + dateStrFormat + "]";
                    if (exceptionStr.equalsIgnoreCase(e.getMessage())) {
                        log.info((Object)"expected exception message");
                        break block11;
                    }
                    Assert.fail((String)("Unexpected exception message: " + e.getMessage()));
                }
            }
            catch (Exception e) {
                log.error((Object)"unexpected exception");
                Assert.fail((String)e.getMessage());
            }
        }
    }
}

