/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.CommonsGlobals;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;

public final class DateUtil {
    private static final Logger LOG = Logger.getLogger((String)DateUtil.class.getName());
    public static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd";
    public static final String XML_GREG_CAL_DATE = "yyyy-MM-dd'T'HH:mm:ss";
    private static final DateFormat XML_GREG_CAL_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static Map<String, String> DAYS_IN_MONTH = null;

    private DateUtil() {
    }

    public static Date date(int year, int month, int date) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.set(year, month, date, 0, 0, 1);
        return cal.getTime();
    }

    public static boolean isValidDate(int year, int month, int day) {
        try {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setLenient(false);
            gc.set(1, year);
            gc.set(2, month - 1);
            gc.set(5, day);
            gc.getTime();
        }
        catch (Exception e) {
            LOG.error((Object)("Exception caught parsing date:" + e.getMessage()));
            return false;
        }
        return true;
    }

    public static boolean isValidDate(String dateStr) {
        if (StringUtils.isBlank((String)dateStr)) {
            LOG.warn((Object)"Date string is null/empty");
            return false;
        }
        if (dateStr.length() != DEFAULT_DATE_FORMAT.length()) {
            LOG.warn((Object)(dateStr + " is not same length as " + DEFAULT_DATE_FORMAT));
            return false;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
            df.setLenient(false);
            Date d = df.parse(dateStr);
            LOG.debug((Object)("Date is ok = " + d));
        }
        catch (ParseException e) {
            LOG.error((Object)("ParseException caught:" + e.getMessage()));
            return false;
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Invalid date");
            return false;
        }
        return true;
    }

    public static boolean isValidDate(String dateStr, String dateStrFormat) {
        if (StringUtils.isBlank((String)dateStr) || StringUtils.isBlank((String)dateStrFormat)) {
            LOG.warn((Object)"Date string or date format string is null/empty");
            return false;
        }
        if (dateStr.length() != dateStrFormat.length()) {
            LOG.warn((Object)(dateStr + " is not same length as " + dateStrFormat));
            return false;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(dateStrFormat);
            sdf.setLenient(false);
            Date d = sdf.parse(dateStr);
            LOG.debug((Object)("Date is ok = " + d + "(" + dateStr + ")"));
        }
        catch (ParseException e) {
            LOG.error((Object)("ParseException caught:" + e.getMessage()));
            return false;
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Invalid date");
            return false;
        }
        return true;
    }

    public static boolean isValidDateFormat(String dateToValidate) {
        if (!dateToValidate.matches("[0-9]{2}/[0-9]{2}/[0-9]{4}")) {
            return false;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
            formatter.setLenient(false);
            formatter.parse(dateToValidate);
            return true;
        }
        catch (Exception e) {
            LOG.debug((Object)("Invalid date - " + dateToValidate), (Throwable)e);
            return false;
        }
    }

    public static Date stringToDate(String dateStr, String dateStrFormat) throws Exception {
        if (StringUtils.isBlank((String)dateStr)) {
            throw new Exception("Date string is blank");
        }
        if (StringUtils.isBlank((String)dateStrFormat)) {
            throw new Exception("Date format string is blank");
        }
        if (dateStr.length() != dateStrFormat.length()) {
            throw new Exception("Date string [" + dateStr + "] is not same length as the date format string [" + dateStrFormat + "]");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateStrFormat);
        sdf.setLenient(false);
        return sdf.parse(dateStr, new ParsePosition(0));
    }

    public static Date stringToDateSilently(String dateStr, String dateFormat) {
        return DateUtil.stringToDateQuietly(dateStr, dateFormat);
    }

    public static Date stringToDateQuietly(String dateStr, String dateFormat) {
        Date date = null;
        try {
            date = DateUtil.stringToDate(dateStr, dateFormat);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static String dateToString(Date date, String dateFormat) throws Exception {
        if (date == null) {
            throw new Exception("Date is null");
        }
        if (StringUtils.isBlank((String)dateFormat)) {
            throw new Exception("Date format string is blank");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setTimeZone(TimeZone.getTimeZone("America/New_York"));
        return sdf.format(date);
    }

    public static String dateToStringQuietly(Date date, String dateFormat) {
        if (date == null) {
            LOG.info((Object)"Date is null");
            return null;
        }
        if (StringUtils.isBlank((String)dateFormat)) {
            LOG.info((Object)"Date format string is blank");
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            return sdf.format(date);
        }
        catch (Exception e) {
            LOG.info((Object)("Exception caught formatting date: " + date));
            return null;
        }
    }

    public static String format(Date date, String dateFormat) throws Exception {
        return DateUtil.dateToString(date, dateFormat);
    }

    public static String formatQuietly(Date date, String dateFormat) {
        return DateUtil.dateToStringQuietly(date, dateFormat);
    }

    public static String formatQuietly(Date date, String dateFormat, String defaultValue) {
        String s = DateUtil.dateToStringQuietly(date, dateFormat);
        if (s == null) {
            s = defaultValue;
        }
        return s;
    }

    public static String formatQuietly(String dateStr, String currentDateFormat, String targetDateFormat, String defaultValue) {
        Date d = DateUtil.stringToDateQuietly(dateStr, currentDateFormat);
        if (d == null) {
            return defaultValue;
        }
        String s = DateUtil.dateToStringQuietly(d, targetDateFormat);
        if (s == null) {
            s = defaultValue;
        }
        return s;
    }

    public static String formatQuietly(String dateFormat) {
        return DateUtil.dateToStringQuietly(new Date(), dateFormat);
    }

    public static String formatGdgQuietly(Date date) {
        String s = DateUtil.dateToStringQuietly(date, "MM-dd-yyyy");
        if (s == null) {
            s = "";
        }
        return s;
    }

    public static String formatGdgLongQuietly(Date date) {
        String s = DateUtil.dateToStringQuietly(date, "MMM dd, yyyy");
        if (s == null) {
            s = "";
        }
        return s;
    }

    public static boolean isBefore(String beginDateStr, String endDateStr, String dateStrFormat) throws Exception {
        Date beginDate = DateUtil.stringToDate(beginDateStr, dateStrFormat);
        Date endDate = DateUtil.stringToDate(endDateStr, dateStrFormat);
        if (beginDate == null || endDate == null) {
            return false;
        }
        return DateUtil.isBefore(beginDate, endDate);
    }

    public static boolean isBefore(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            return false;
        }
        GregorianCalendar calBegin = DateUtil.getGregorianCal(beginDate);
        GregorianCalendar calEnd = DateUtil.getGregorianCal(endDate);
        return calBegin.before(calEnd);
    }

    public static boolean isToday(Date date) {
        if (date == null) {
            return false;
        }
        Date today = Calendar.getInstance().getTime();
        return DateUtils.isSameDay((Date)date, (Date)today);
    }

    public static boolean isBeforeToday(Date date) {
        if (date == null) {
            return false;
        }
        Date today = Calendar.getInstance().getTime();
        if (DateUtils.isSameDay((Date)date, (Date)today)) {
            return false;
        }
        return date.before(today);
    }

    public static boolean isAfterToday(Date date) {
        if (date == null) {
            return false;
        }
        Date today = Calendar.getInstance().getTime();
        if (DateUtils.isSameDay((Date)date, (Date)today)) {
            return false;
        }
        return date.after(today);
    }

    public static boolean isTodayOrAfter(Date date) {
        if (date == null) {
            return false;
        }
        Date today = Calendar.getInstance().getTime();
        if (DateUtils.isSameDay((Date)date, (Date)today)) {
            return true;
        }
        return date.after(today);
    }

    public static boolean isNotBeforeToday(Date date) {
        if (date == null) {
            return false;
        }
        Date today = Calendar.getInstance().getTime();
        if (DateUtils.isSameDay((Date)date, (Date)today)) {
            return true;
        }
        return date.after(today);
    }

    public static boolean isNotAfterToday(Date date) {
        if (date == null) {
            return false;
        }
        Date today = Calendar.getInstance().getTime();
        if (DateUtils.isSameDay((Date)date, (Date)today)) {
            return true;
        }
        return date.before(today);
    }

    public static boolean isBefore2(Date date1, Date date2) {
        if (DateUtils.isSameDay((Date)date1, (Date)date2)) {
            return false;
        }
        return date1.before(date2);
    }

    public static boolean isAfter2(Date date1, Date date2) {
        if (DateUtils.isSameDay((Date)date1, (Date)date2)) {
            return false;
        }
        return date1.after(date2);
    }

    public static Date getNextDate(Date beginDate, int calendarField, int amount) {
        GregorianCalendar endDate = DateUtil.getGregorianCal(beginDate);
        endDate.add(calendarField, amount);
        return endDate.getTime();
    }

    public static int getDaysInMonth(int year, int month) {
        GregorianCalendar today = (GregorianCalendar)Calendar.getInstance();
        today.set(1, year);
        int daysInMonth = 0;
        String monthStr = String.valueOf(month);
        if (DAYS_IN_MONTH == null) {
            DateUtil.initDaysInMonthMap();
        }
        daysInMonth = today.isLeapYear(today.get(1)) && month == 2 ? Integer.parseInt(DAYS_IN_MONTH.get(monthStr)) : Integer.parseInt(DAYS_IN_MONTH.get(monthStr));
        return daysInMonth;
    }

    public static Date getTodayDate() {
        Calendar today = Calendar.getInstance();
        return today.getTime();
    }

    public static Date getAlternateDate(int calendarField, int offset) {
        Calendar today = Calendar.getInstance();
        today.add(calendarField, offset);
        return today.getTime();
    }

    public static Date getDate(Date beginDate, int calendarField, int value) {
        GregorianCalendar endDate = DateUtil.getGregorianCal(beginDate);
        endDate.set(calendarField, value);
        return endDate.getTime();
    }

    public static Date getDate(int year, int month, int day) {
        if (year == 0 || month == 0 || day == 0) {
            return null;
        }
        GregorianCalendar newDate = (GregorianCalendar)Calendar.getInstance();
        int maxDays = 0;
        newDate.set(1, year);
        newDate.set(2, month - 1);
        maxDays = newDate.getActualMaximum(5);
        if (day > maxDays) {
            day = maxDays;
        }
        newDate.set(5, day);
        return newDate.getTime();
    }

    public static Date getDateTime(int year, int month, int day, int hourOfDay, int minute, int second) {
        if (year == 0 || month == 0 || day == 0) {
            return null;
        }
        GregorianCalendar newDate = (GregorianCalendar)Calendar.getInstance();
        int maxDays = 0;
        newDate.set(1, year);
        newDate.set(2, month - 1);
        maxDays = newDate.getActualMaximum(5);
        if (day > maxDays) {
            day = maxDays;
        }
        newDate.set(5, day);
        newDate.set(11, hourOfDay);
        newDate.set(12, minute);
        newDate.set(13, second);
        return newDate.getTime();
    }

    public static String getTodayDateStr(String dateFormat) throws Exception {
        return DateUtil.dateToString(DateUtil.getTodayDate(), dateFormat);
    }

    public static String getAlternateDateStr(int calendarField, int offset, String dateFormat) throws Exception {
        return DateUtil.dateToString(DateUtil.getAlternateDate(calendarField, offset), dateFormat);
    }

    public static long getDiffDays(Date startDate, Date endDate) {
        long diffDays = endDate.getTime() - startDate.getTime();
        return diffDays / 86400000L;
    }

    public static String getCurrTime(String timeFormat) throws Exception {
        return DateUtil.getTodayDateStr(timeFormat);
    }

    public static long getUTC() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        return date.getTime();
    }

    public static Date getBeginWeekDate(int beginDayOfWeek, Date currentDate) throws Exception {
        LOG.debug((Object)("==>currentDate=" + DateUtil.dateToString(currentDate, "yyyy-MM-dd")));
        GregorianCalendar today = DateUtil.getGregorianCal(currentDate);
        int currDayOfWeek = today.get(7);
        LOG.debug((Object)("==> currDayOfWeek=" + currDayOfWeek));
        int numDays = 0;
        if (currDayOfWeek > beginDayOfWeek) {
            numDays = currDayOfWeek - beginDayOfWeek;
            today.add(5, -numDays);
            LOG.debug((Object)("after begin: getting info for [" + (numDays + 1) + "] days"));
        } else if (currDayOfWeek < beginDayOfWeek) {
            numDays = 7 - (beginDayOfWeek - currDayOfWeek);
            today.add(5, -numDays);
            LOG.debug((Object)("before begin: getting info for [" + numDays + "] days"));
        }
        LOG.debug((Object)("==>returning begin date=" + DateUtil.dateToString(today.getTime(), "yyyy-MM-dd")));
        return today.getTime();
    }

    public static int getAgeYears(Date birthDate) {
        GregorianCalendar dob = DateUtil.getGregorianCal(birthDate);
        GregorianCalendar today = (GregorianCalendar)Calendar.getInstance();
        int currYear = today.get(1);
        int currMonth = today.get(2);
        ++currMonth;
        int currDay = today.get(5);
        int dobYear = dob.get(1);
        int dobMonth = dob.get(2);
        int dobDay = dob.get(5);
        int years = currYear - dobYear;
        if (dobMonth > currMonth) {
            --years;
        } else if (dobMonth == currMonth && dobDay > currDay) {
            --years;
        }
        return years;
    }

    public static int getAgeYears(Date birthDate, Date deathDate) {
        GregorianCalendar dob = DateUtil.getGregorianCal(birthDate);
        int dobYear = dob.get(1);
        int dobMonth = dob.get(2);
        int dobDay = dob.get(5);
        GregorianCalendar dod = DateUtil.getGregorianCal(birthDate);
        int dodYear = dod.get(1);
        int dodMonth = dod.get(2);
        int dodDay = dod.get(5);
        int years = dodYear - dobYear;
        if (dobMonth > dodMonth) {
            --years;
        } else if (dobMonth == dodMonth && dobDay > dodDay) {
            --years;
        }
        return years;
    }

    public static int getYear(Date date) {
        if (date == null) {
            LOG.warn((Object)"date is null => returning '0'");
            return 0;
        }
        return DateUtil.getGregorianCal(date).get(1);
    }

    public static int getMonth(Date date) {
        if (date == null) {
            LOG.warn((Object)"date is null => returning '0'");
            return 0;
        }
        return DateUtil.getGregorianCal(date).get(2) + 1;
    }

    public static int getDayOfMonth(Date date) {
        if (date == null) {
            LOG.warn((Object)"date is null => returning '0'");
            return 0;
        }
        return DateUtil.getGregorianCal(date).get(5);
    }

    public static GregorianCalendar getGregorianCal(Date date) {
        GregorianCalendar cal = (GregorianCalendar)Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Calendar getMidnight() {
        Calendar midnight = Calendar.getInstance();
        midnight.add(5, 1);
        midnight.set(11, 0);
        midnight.set(12, 0);
        midnight.set(13, 0);
        midnight.set(14, 0);
        return midnight;
    }

    public static Calendar getEndOfToday() {
        Calendar c = Calendar.getInstance(CommonsGlobals.DEFAULT_TIMEZONE);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c;
    }

    public static Calendar getStartOfToday() {
        Calendar c = Calendar.getInstance(CommonsGlobals.DEFAULT_TIMEZONE);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c;
    }

    private static void initDaysInMonthMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "31");
        m.put("2", "28");
        m.put("3", "31");
        m.put("4", "30");
        m.put("5", "31");
        m.put("6", "30");
        m.put("7", "31");
        m.put("8", "31");
        m.put("9", "30");
        m.put("10", "31");
        m.put("11", "30");
        m.put("12", "31");
        DAYS_IN_MONTH = m;
    }

    public static Date clearTime(Date dt) {
        GregorianCalendar calendar = new GregorianCalendar();
        if (dt != null) {
            calendar.setTime(dt);
            calendar.set(10, 0);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.set(9, 0);
            return calendar.getTime();
        }
        return dt;
    }

    public static XMLGregorianCalendar getXMLGregorianCalendar(String dateAsString) {
        XMLGregorianCalendar retVal = null;
        try {
            XML_GREG_CAL_DATE_FORMATTER.setLenient(false);
            Date date = XML_GREG_CAL_DATE_FORMATTER.parse(dateAsString, new ParsePosition(0));
            if (date != null) {
                retVal = DateUtil.getXMLGregorianCalendar(date);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Invalid Date, Reason --> " + e.getMessage()));
        }
        return retVal;
    }

    public static XMLGregorianCalendar getXMLGregorianCalendar(Date date) {
        XMLGregorianCalendar xmlCalendar = null;
        if (date != null) {
            GregorianCalendar gCalendar = new GregorianCalendar();
            gCalendar.setTime(date);
            try {
                xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
            }
            catch (DatatypeConfigurationException e) {
                LOG.error((Object)("Invalid Date, Reason --> " + e.getMessage()));
            }
        }
        return xmlCalendar;
    }
}

