/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class ConversionUtils {
    private static Logger log = Logger.getLogger((String)"gov.gsa.grants.find.util.ConversionUtils");
    private static final Pattern NONASCII_PATTERN;
    private static final Pattern UNWANTED_CHARACTER_PATTERN;
    private static final Perl5Substitution EMPTY_STR_SUB;
    private static final String EMPTY_STR = "";

    public static String listToString(List l) {
        StringBuffer sb = null;
        if (l != null) {
            Iterator i = l.iterator();
            if (i.hasNext()) {
                sb = new StringBuffer();
                sb.append((String)i.next());
            }
            while (i.hasNext()) {
                sb.append(",");
                sb.append((String)i.next());
            }
        }
        if (sb != null) {
            log.debug((Object)sb.toString());
            return sb.toString();
        }
        return null;
    }

    public static String cleanText(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return EMPTY_STR;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        String cleanText1 = Util.substitute((PatternMatcher)matcher, (Pattern)UNWANTED_CHARACTER_PATTERN, (Substitution)EMPTY_STR_SUB, (String)text, (int)-1);
        String cleanText = Util.substitute((PatternMatcher)matcher, (Pattern)NONASCII_PATTERN, (Substitution)EMPTY_STR_SUB, (String)StringEscapeUtils.escapeXml((String)cleanText1), (int)-1);
        try {
            cleanText = new String(cleanText.getBytes("UTF-8"), "UTF-8");
            return new String(cleanText.getBytes("UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage());
            log.debug((Object)("returning: " + cleanText));
            return cleanText;
        }
    }

    public static String cleanTextJAXB2(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return text;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        String cleanText1 = Util.substitute((PatternMatcher)matcher, (Pattern)UNWANTED_CHARACTER_PATTERN, (Substitution)EMPTY_STR_SUB, (String)text, (int)-1);
        String cleanText = Util.substitute((PatternMatcher)matcher, (Pattern)NONASCII_PATTERN, (Substitution)EMPTY_STR_SUB, (String)StringEscapeUtils.escapeXml((String)cleanText1), (int)-1);
        try {
            return new String(cleanText.getBytes("UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage());
            log.debug((Object)("returning: " + cleanText));
            return cleanText;
        }
    }

    static {
        EMPTY_STR_SUB = new Perl5Substitution(" ");
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            UNWANTED_CHARACTER_PATTERN = compiler.compile("[\udc07|\udbc0|\udc0f|\udc03|\udc05|\udc06|\udc08]");
            NONASCII_PATTERN = compiler.compile("[^a-zA-Z0-9 !@#$%\\^&*()_+=\\-,\\./';\\[\\]\\\\|}{\":?><~`]");
        }
        catch (MalformedPatternException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

