/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.bizobj.GGCertificate;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class CertificateUtil {
    private static final Logger log = Logger.getLogger((String)CertificateUtil.class.getName());

    private CertificateUtil() {
    }

    public static GGCertificate getCert(HttpServletRequest request) {
        log.debug((Object)"Get javax.servlet.request.X509Certificate from request");
        GGCertificate cert = null;
        if (request.getAttribute("javax.servlet.request.X509Certificate") != null) {
            log.debug((Object)"Found javax.servlet.request.X509Certificate in the request");
            X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            if (certs != null && certs.length > 0) {
                log.debug((Object)("Setting cert=" + certs[0]));
                cert = new GGCertificate(certs[0]);
            }
        }
        log.debug((Object)("Returning cert=" + cert));
        return cert;
    }

    public static String getCertId(HttpServletRequest request) {
        log.debug((Object)"Get javax.servlet.request.X509Certificate from request");
        String certId = null;
        if (request.getAttribute("javax.servlet.request.X509Certificate") != null) {
            log.debug((Object)"Found javax.servlet.request.X509Certificate in the request");
            X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            if (certs != null) {
                log.debug((Object)("Setting cert=" + certs[0]));
                certId = certs[0].getSerialNumber().toString();
            }
        }
        return certId;
    }

    public static X509Certificate getCert(String base64EncodedStr) throws Exception {
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] certBytes = decoder.decode(base64EncodedStr);
            log.info((Object)("cert bytes length: " + certBytes.length));
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes));
            log.info((Object)("cert serial / issuer principal: " + cert.getSerialNumber() + " >>> " + cert.getIssuerX500Principal()));
            return cert;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public static void main(String[] args) {
    }
}

