/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.CommonsGlobals;
import gov.grants.commons.bizobj.GGSSOUser;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AuthorizationUtil {
    private static final Logger LOG = Logger.getLogger((String)AuthorizationUtil.class.getName());
    private static final String PAGE_AUTH_PROPS_FILE = CommonsGlobals.SYSTEM_CONFIG_DIR + File.separator + "page-authorization.properties";
    private static final Properties PAGE_AUTH_PROPS = new Properties();
    private static final String EXCLUDE_PAGE_AUTH_PROPS_FILE = CommonsGlobals.SYSTEM_CONFIG_DIR + File.separator + "page-authorization-exclude.properties";
    private static final Properties EXCLUDE_PAGE_AUTH_PROPS = new Properties();
    private static String EXCLUDE_FILE_EXT_REGEX = null;
    private static Pattern EXCLUDE_FILE_EXT_PATTERN = null;

    private AuthorizationUtil() {
    }

    public static boolean isAuthorized(String uri, GGSSOUser profile) {
        return AuthorizationUtil.isAuthorized(uri, profile.getRoles());
    }

    public static boolean isAuthorized(String uri, Collection<String> userPrivileges) {
        boolean isAuthorized = true;
        if (PAGE_AUTH_PROPS.containsKey(uri)) {
            isAuthorized = false;
            String value = PAGE_AUTH_PROPS.getProperty(uri);
            if (!value.trim().isEmpty()) {
                String[] reqPrivileges;
                LOG.debug((Object)("prop value: " + value));
                for (String privilege : reqPrivileges = StringUtils.split((String)value, (String)"|")) {
                    LOG.debug((Object)("check for req privilege: " + privilege));
                    if (!userPrivileges.contains(privilege)) continue;
                    isAuthorized = true;
                    break;
                }
            } else {
                isAuthorized = true;
            }
        }
        return isAuthorized;
    }

    public static boolean isAuthorizedNoRole(String uri) {
        String value;
        boolean isAuthorized = false;
        if (PAGE_AUTH_PROPS.containsKey(uri) && (value = PAGE_AUTH_PROPS.getProperty(uri)).trim().isEmpty()) {
            isAuthorized = true;
        }
        return isAuthorized;
    }

    public static boolean excludePageAuth(String uri) {
        boolean exclude = true;
        try {
            Matcher m = EXCLUDE_FILE_EXT_PATTERN.matcher(uri);
            exclude = m.matches();
            LOG.debug((Object)(uri + " matches: " + exclude));
            if (!exclude) {
                LOG.debug((Object)"check URI white list");
                exclude = EXCLUDE_PAGE_AUTH_PROPS.containsKey(uri);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Exception: " + e.getMessage()));
        }
        return exclude;
    }

    public static boolean isLoginNeeded(String uri) {
        boolean authNeeded = false;
        try {
            LOG.debug((Object)"check URI page-authorization.properties list");
            authNeeded = PAGE_AUTH_PROPS.containsKey(uri);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception: " + e.getMessage()));
        }
        return authNeeded;
    }

    private static void init() {
        try {
            AuthorizationUtil.loadProps();
            String fileExtensions = EXCLUDE_PAGE_AUTH_PROPS.getProperty("exclude-file-ext");
            LOG.info((Object)("initialize file ext white list: " + fileExtensions));
            EXCLUDE_FILE_EXT_REGEX = "^.*\\.(" + fileExtensions + ")$";
            LOG.info((Object)("exclude file ext regex: " + EXCLUDE_FILE_EXT_REGEX));
            EXCLUDE_FILE_EXT_PATTERN = Pattern.compile(EXCLUDE_FILE_EXT_REGEX);
            String testURI = "/apply/js/my-javascript.js";
            Matcher m = EXCLUDE_FILE_EXT_PATTERN.matcher(testURI);
            LOG.debug((Object)(testURI + " matches: " + m.matches()));
        }
        catch (Exception e) {
            LOG.error((Object)("Exception: " + e));
            e.printStackTrace();
        }
    }

    private static void loadProps() {
        try {
            File f = new File(PAGE_AUTH_PROPS_FILE);
            if (!f.exists()) {
                String msg = PAGE_AUTH_PROPS_FILE + " does not exist";
                LOG.error((Object)msg);
                throw new Exception(msg);
            }
            LOG.info((Object)("Loading: " + PAGE_AUTH_PROPS_FILE));
            PAGE_AUTH_PROPS.load(new FileInputStream(f));
            LOG.info((Object)("test property: " + PAGE_AUTH_PROPS.getProperty("test")));
            f = new File(EXCLUDE_PAGE_AUTH_PROPS_FILE);
            if (!f.exists()) {
                String msg = EXCLUDE_PAGE_AUTH_PROPS_FILE + " does not exist";
                LOG.error((Object)msg);
                throw new Exception(msg);
            }
            LOG.info((Object)("Loading: " + EXCLUDE_PAGE_AUTH_PROPS_FILE));
            EXCLUDE_PAGE_AUTH_PROPS.load(new FileInputStream(f));
            LOG.info((Object)("exclude page auth test property: " + EXCLUDE_PAGE_AUTH_PROPS.getProperty("test")));
            String testKey = "/apply/jsp/testPage.jsp";
            LOG.info((Object)("exclude page auth list contains test key[" + testKey + "]: " + EXCLUDE_PAGE_AUTH_PROPS.containsKey(testKey)));
        }
        catch (Exception e) {
            LOG.error((Object)("Exception, could not load " + EXCLUDE_PAGE_AUTH_PROPS_FILE + ": " + e));
            e.printStackTrace();
        }
    }

    static {
        AuthorizationUtil.init();
    }
}

