/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.util;

import gov.grants.commons.CommonsGlobals;
import gov.grants.commons.bizobj.Activity;
import gov.grants.commons.test.BaseTest;
import gov.grants.commons.util.FileUtil;
import gov.grants.commons.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class ActivityUtil {
    private static final Logger log = Logger.getLogger((String)ActivityUtil.class.getName());
    private static Map<String, Activity> ACTIVITY_MAP = new HashMap<String, Activity>();
    private static boolean orderByNumber;
    private static boolean orderByCategory;
    private static final String ACTIVITY_XPATH = "//Activity";
    private static final String ORDER_BY_NUMBER_XPATH = "//OrderByNumber";
    private static final String ORDER_BY_CATEGORY_XPATH = "//OrderByCategory";
    private static final String ACTIVITYID_ELEMENT = "activityID";
    private static final String ORDER_NUMBER_ELEMENT = "orderNumber";
    private static final String LABEL_ELEMENT = "label";
    private static final String HELP_TEXT_ELEMENT = "helpText";
    private static final String LANDING_URL_ELEMENT = "landingURL";
    private static final String TARGET_ELEMENT = "target";
    private static final String CATEGORYID_ELEMENT = "categoryID";

    private ActivityUtil() {
    }

    public static boolean isActivity(String activityID) {
        return ACTIVITY_MAP.containsKey(activityID);
    }

    public static List<Activity> getActivities(Collection<String> activityIds) {
        if (activityIds == null) {
            return null;
        }
        HashSet<Activity> activities = new HashSet<Activity>();
        for (String activityId : activityIds) {
            Activity activity = new Activity();
            activity = ACTIVITY_MAP.get(activityId);
            if (activity != null) {
                log.debug((Object)(activity + " exists"));
                activities.add(activity);
                continue;
            }
            log.debug((Object)("No activities exists in activity.xml" + activity));
        }
        log.debug((Object)("Returning activities: " + activities));
        ArrayList<Activity> sortedActivities = new ArrayList<Activity>();
        sortedActivities.addAll(activities);
        if (orderByNumber) {
            Collections.sort(sortedActivities, new Activity.SortByOrderNumber());
        }
        if (orderByCategory) {
            Collections.sort(sortedActivities, new Activity.SortByCategoryID());
        }
        return sortedActivities;
    }

    public static Activity getActivity(String activityId) {
        return ACTIVITY_MAP.get(activityId);
    }

    private static void init() {
        try {
            String configDir = CommonsGlobals.SYSTEM_CONFIG_DIR;
            log.info((Object)("--- configDir=" + configDir));
            String activityXml = configDir + System.getProperty("file.separator") + "Activity.xml";
            log.info((Object)("--- Reading avtivity XML=" + activityXml));
            byte[] fileBytes = FileUtil.readFile(activityXml);
            orderByNumber = Boolean.parseBoolean(XMLUtil.getElements(new ByteArrayInputStream(fileBytes), ORDER_BY_NUMBER_XPATH).get(0).getTextTrim());
            orderByCategory = Boolean.parseBoolean(XMLUtil.getElements(new ByteArrayInputStream(fileBytes), ORDER_BY_CATEGORY_XPATH).get(0).getTextTrim());
            List<Element> activityList = XMLUtil.getElements(new ByteArrayInputStream(fileBytes), ACTIVITY_XPATH);
            String activityID = null;
            for (Element e : activityList) {
                activityID = StringUtils.defaultString((String)e.element(ACTIVITYID_ELEMENT).getTextTrim());
                log.info((Object)("--- ActivityID=" + activityID));
                Activity activity = new Activity();
                try {
                    activity.setActivityID(activityID);
                    activity.setCategoryID(StringUtils.defaultString((String)e.element(CATEGORYID_ELEMENT).getTextTrim()));
                    activity.setHelpText(StringUtils.defaultString((String)e.element(HELP_TEXT_ELEMENT).getTextTrim()));
                    activity.setLabel(StringUtils.defaultString((String)e.element(LABEL_ELEMENT).getTextTrim()));
                    activity.setLandingURL(StringUtils.defaultString((String)e.element(LANDING_URL_ELEMENT).getTextTrim()));
                    activity.setOrderNumber(Integer.parseInt(StringUtils.defaultIfEmpty((String)e.element(ORDER_NUMBER_ELEMENT).getTextTrim(), (String)"0")));
                    activity.setTarget(StringUtils.defaultString((String)e.element(TARGET_ELEMENT).getTextTrim()));
                }
                catch (Exception e1) {
                    log.error((Object)("Initialization error:\n" + e1.getMessage()));
                    e1.printStackTrace();
                }
                ACTIVITY_MAP.put(activityID, activity);
            }
            log.info((Object)("Roles and activities successfully added:" + ACTIVITY_MAP));
        }
        catch (Exception e) {
            log.error((Object)("Initialization error:\n" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        BaseTest btc = new BaseTest();
        ActivityUtil.init();
        ArrayList<String> activities = new ArrayList<String>();
        activities.add("OpportunitiesReport");
        activities.add("ApplicantChecklist");
        activities.add("ApplicantAuditReport");
        activities.add("SubmissionReport");
        ActivityUtil.getActivities(activities);
    }

    static {
        ActivityUtil.init();
    }
}

