/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.type;

public enum SolrDocType {
    SYNOPSIS("synopsis", "Synopsis"),
    FORECAST("forecast", "Forecast");

    private final String key;
    private final String displayValue;

    private SolrDocType(String key, String displayValue) {
        this.key = key;
        this.displayValue = displayValue;
    }

    public String key() {
        return this.key;
    }

    public String displayValue() {
        return this.displayValue;
    }

    public static SolrDocType fromKey(String key) {
        for (SolrDocType type : SolrDocType.values()) {
            if (!type.key().equalsIgnoreCase(key)) continue;
            return type;
        }
        return null;
    }

    public static SolrDocType fromDisplayValue(String displayValue) {
        for (SolrDocType type : SolrDocType.values()) {
            if (!type.displayValue().equalsIgnoreCase(displayValue)) continue;
            return type;
        }
        return null;
    }

    public static SolrDocType fromString(String docType) {
        for (SolrDocType type : SolrDocType.values()) {
            if (!type.toString().equalsIgnoreCase(docType)) continue;
            return type;
        }
        return null;
    }
}

