/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.type;

public enum PrivilegeType {
    MANAGE_ORG("ManageOrganization", "Manage Organization"),
    VIEW_ORG("ViewOrganization", "View Organization"),
    MANAGE_APPLICANTS_ALL_ROLES("ManageApplicantsAllRoles", "Manage Applicants - All Roles"),
    MANAGE_APPLICANTS_BASIC_WS_ROLES("ManageApplicantsWSRoles", "Manage Applicants - Basic Workspace Roles"),
    MANAGE_CERTS("ManageCertificates", "Manage Certificates"),
    CREATE_WS("CreateWorkspace", "Create Workspace"),
    OWN_WS("OwnWorkspace", "Own Workspace"),
    MANAGE_PARTICIPANTS_ORG_WS("ManageParticipantOrgWS", "Manage Participants for Organization Workspaces"),
    MANAGE_PARTICIPANTS_OWN_WS("ManageParticipantMyWS", "Manage Participants for My Workspaces"),
    PARTICIPANT_ACTIVITIES_ORG_WS("ParticipantActivitiesOrgWS", "Participant Activities for Organization Workspaces"),
    SUBMIT_APPLICATIONS_ORG("SubmitApplicationsOrg", "Submit Applications for Organization Workspaces"),
    SUBMIT_APPLICATIONS_OWN("SubmitMyApplications", "Submit Applications for My Workspaces"),
    CHECK_APPLICATION_STATUS_ORG("CheckApplicationStatusOrg", "Check Application Status for Organization"),
    CHECK_APPLICATION_STATUS_OWN("CheckMyApplicationStatus", "Check My Application Status"),
    AGENCY_ASSIGNER("AgencyAssigner", "Agency Tracking Number/Notes Assigner"),
    AGENCY_GRANT_RETRIEVER("AgencyGrantRetriever", "Agency Grant Retriever"),
    AGENCY_REPORT_VIEWER("AgencyReportViewer", "Agency Report Viewer"),
    AGENCY_TEMPLATE_CREATOR("AgencyTemplateCreator", "Agency Template Creator"),
    AGENCY_VIEWER("AgencyViewer", "View Applications"),
    MANAGE_AGENCIES("ManageAgencies", "Manage Agencies"),
    MANAGE_PACKAGES("ManagePackages", "Manage Packages"),
    MANAGE_SYNOPSIS("ManageSynopsis", "Manage Synopses"),
    MANAGE_FORECAST("ManageForecast", "Manage Forecast"),
    MANAGE_GRANTORS("ManageGrantors", "Manage Grantors"),
    REPORT_VIEWER("ReportViewer", "Admin Report Viewer"),
    THIRD_PARTY_SUBMITTER("ThirdPartySubmitter", "Third Party Submitter");

    private final String privilegeName;
    private final String title;

    private PrivilegeType(String privilegeName, String title) {
        this.privilegeName = privilegeName;
        this.title = title;
    }

    public String privilegeName() {
        return this.privilegeName;
    }

    public String title() {
        return this.title;
    }

    public static PrivilegeType fromPrivilegeName(String privilegeName) {
        for (PrivilegeType type : PrivilegeType.values()) {
            if (!type.privilegeName().equalsIgnoreCase(privilegeName)) continue;
            return type;
        }
        return null;
    }

    public static PrivilegeType fromTitle(String title) {
        for (PrivilegeType type : PrivilegeType.values()) {
            if (!type.title().equalsIgnoreCase(title)) continue;
            return type;
        }
        return null;
    }
}

