/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.type;

public enum OpportunityStatusType {
    POSTED("posted"),
    CLOSED("closed"),
    ARCHIVED("archived"),
    FORECASTED("forecasted");

    private final String displayValue;

    private OpportunityStatusType(String displayValue) {
        this.displayValue = displayValue;
    }

    public String displayValue() {
        return this.displayValue;
    }

    public static OpportunityStatusType[] synopsisOppStatuses() {
        OpportunityStatusType[] types = new OpportunityStatusType[]{POSTED, CLOSED, ARCHIVED};
        return types;
    }

    public static OpportunityStatusType[] forecastOppStatuses() {
        OpportunityStatusType[] types = new OpportunityStatusType[]{FORECASTED, ARCHIVED};
        return types;
    }

    public static OpportunityStatusType fromDisplayValue(String displayValue) {
        for (OpportunityStatusType type : OpportunityStatusType.values()) {
            if (!type.displayValue().equalsIgnoreCase(displayValue)) continue;
            return type;
        }
        return null;
    }

    public static OpportunityStatusType fromString(String status) {
        for (OpportunityStatusType type : OpportunityStatusType.values()) {
            if (!type.toString().equalsIgnoreCase(status)) continue;
            return type;
        }
        return null;
    }
}

