/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.type;

import java.util.ArrayList;

public enum LdapAttributeType {
    CN("cn"),
    UID("uid"),
    SN("sn"),
    PASSWORD("userPassword"),
    SECURITYANS("securityanswer"),
    SECURITYQSN("securityquestion"),
    PWD_CHANGE_TIME("pwdChangedTime"),
    PWD_LOCK_TIME("pwdAccountLockedTime"),
    PWD_FAILURE_TIME("pwdFailureTime"),
    PWD_MAX_AGE("pwdMaxAge"),
    PWD_EXPIRE_WARNING("pwdExpireWarning"),
    USER_ACTIVE_STATUS("active"),
    LAST_AUTH_TIME("pwdLastAuthTime");

    private final String attrName;
    private static String[] attrNamesUpperCase;
    private static String[] userInfoAttrNamesUpperCase;

    private LdapAttributeType(String attrName) {
        this.attrName = attrName;
    }

    public String attrName() {
        return this.attrName;
    }

    public static LdapAttributeType fromAttrName(String attrName) {
        for (LdapAttributeType type : LdapAttributeType.values()) {
            if (!type.attrName().equalsIgnoreCase(attrName)) continue;
            return type;
        }
        return null;
    }

    public static String[] allAttrNamesUpperCase() {
        if (attrNamesUpperCase != null) {
            return attrNamesUpperCase;
        }
        attrNamesUpperCase = new String[LdapAttributeType.values().length];
        int count = 0;
        for (LdapAttributeType type : LdapAttributeType.values()) {
            LdapAttributeType.attrNamesUpperCase[count] = type.attrName.toUpperCase();
            ++count;
        }
        return attrNamesUpperCase;
    }

    public static String[] userInfoAttrNamesUpperCase() {
        if (userInfoAttrNamesUpperCase != null) {
            return userInfoAttrNamesUpperCase;
        }
        ArrayList<String> attrNames = new ArrayList<String>();
        attrNames.add(UID.attrName().toUpperCase());
        attrNames.add(CN.attrName().toUpperCase());
        attrNames.add(SN.attrName().toUpperCase());
        userInfoAttrNamesUpperCase = attrNames.toArray(new String[0]);
        return userInfoAttrNamesUpperCase;
    }
}

