/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.type;

public enum GGUserType {
    APPLICANT("virtual-applicant", "Virtual Applicant", 0),
    EBIZ("ebiz", "EBiz", 1),
    GRANTOR("grantor", "Grantor", 2),
    AGENCY("agency", "Agency", 2),
    APPLICANT_INDV("indv", "Individual Applicant", 3),
    APPLICANT_ORG("applicant", "Organization Applicant", 4),
    APPLICANT_CERTIFICATE("applicant-cert", "Applicant Certificate", 5),
    GRANTOR_CERTIFICATE("grantor-cert", "Grantor Certificate", 6),
    THIRD_PARTY_CERTIFICATE("third-party-cert", "Third Party Certificate", 7),
    SYSTEM("system", "System", 8),
    WORKSPACE_PARTNER("workspace-partner", "Workspace Partner", 9),
    NOPROFILE("noprofile", "No Profile", 10);

    private final String value;
    private final String title;
    private final int id;

    private GGUserType(String value, String title, int id) {
        this.value = value;
        this.title = title;
        this.id = id;
    }

    public String value() {
        return this.value;
    }

    public String title() {
        return this.title;
    }

    public int id() {
        return this.id;
    }

    public static GGUserType fromValue(String value) {
        for (GGUserType type : GGUserType.values()) {
            if (!type.value().equalsIgnoreCase(value)) continue;
            return type;
        }
        return null;
    }

    public static GGUserType fromTitle(String title) {
        for (GGUserType type : GGUserType.values()) {
            if (!type.title().equalsIgnoreCase(title)) continue;
            return type;
        }
        return null;
    }

    public static GGUserType fromId(long id, boolean useGrantor) {
        if (id == (long)GGUserType.GRANTOR.id) {
            if (useGrantor) {
                return GRANTOR;
            }
            return AGENCY;
        }
        for (GGUserType type : GGUserType.values()) {
            if ((long)type.id() != id) continue;
            return type;
        }
        return null;
    }
}

