/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.type;

public enum CoreRoleType {
    INDIVIDUAL_APPLICANT("Individual Applicant", "Individual Applicant"),
    AOR_MANAGER("AORManager", "AOR Manager/EBiz POC"),
    EXPANDED_AOR("Expanded AOR", "Expanded AOR"),
    STANDARD_AOR("Standard AOR", "Standard AOR"),
    WORKSPACE_MANAGER("Workspace Manager", "Workspace Manager");

    private final String roleName;
    private final String description;

    private CoreRoleType(String roleName, String description) {
        this.roleName = roleName;
        this.description = description;
    }

    public String roleName() {
        return this.roleName;
    }

    public String description() {
        return this.description;
    }

    public static CoreRoleType fromRoleName(String roleName) {
        for (CoreRoleType type : CoreRoleType.values()) {
            if (!type.roleName().equalsIgnoreCase(roleName)) continue;
            return type;
        }
        return null;
    }
}

