/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.type;

public enum AuthenticationResultType {
    SUCCESS(0, "Successful", "Successful"),
    SUCCESS_PIVCAC(1, "Successful - PIV / CAC", "Successful - PIV / CAC"),
    ACCOUNT_NOT_FOUND(-1, "No account found", "Found no account"),
    ACCOUNT_INACTIVE(-2, "Account Inactive", "Inactive account"),
    ACCOUNT_LOCKED(-3, "Account locked", "Account locked"),
    INVALID_CREDENTIALS(-4, "Invalid Password", "Invalid credentials"),
    PASSWORD_EXPIRED(-5, "Password Expired", "Password expired"),
    EMAIL_CONFIRMATION_PENDING(-6, "Email pending", "Email pending"),
    REQUIRED_INFORMATION_MISSING(-7, "Missing required information", "Missing required information"),
    DUPLICATED_EMAIL(-8, "Duplicate email", "Duplicate email"),
    EBIZ_ACCOUNT(-9, "EBiz account", "EBiz account"),
    POTENTIAL_DUNS(-10, "Potential Duns", "Potential Duns");

    private int code;
    private String desc;
    private String msg;

    private AuthenticationResultType(int code, String desc, String msg) {
        this.code = code;
        this.desc = desc;
        this.msg = msg;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getMsg() {
        return this.msg;
    }

    public static AuthenticationResultType fromCode(int code) {
        for (AuthenticationResultType authenticationResultType : AuthenticationResultType.values()) {
            if (code != authenticationResultType.getCode()) continue;
            return authenticationResultType;
        }
        return null;
    }
}

