/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.transform;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import gov.grants.commons.transform.GsonExclusionStrategy;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class Transformer {
    private static final Logger log = Logger.getLogger((String)Transformer.class.getName());

    private Transformer() {
    }

    public static String toJson(boolean useJsonpCallback, String callbackName, Object o) {
        try {
            String jsonResult = new Gson().toJson(o);
            if (useJsonpCallback) {
                return Transformer.getJsonpResult(callbackName, jsonResult);
            }
            return jsonResult;
        }
        catch (Exception e) {
            log.error((Object)("exception transforming to JSON: " + ExceptionUtils.getRootCauseMessage((Throwable)e)));
            return "";
        }
    }

    public static String toJsonWithDateFormat(boolean useJsonpCallback, String callbackName, Object o, String dateFormat) {
        try {
            Gson gson = new GsonBuilder().setDateFormat(dateFormat).create();
            String jsonResult = gson.toJson(o);
            if (useJsonpCallback) {
                return Transformer.getJsonpResult(callbackName, jsonResult);
            }
            return jsonResult;
        }
        catch (Exception e) {
            log.error((Object)("exception transforming to JSON: " + ExceptionUtils.getRootCauseMessage((Throwable)e)));
            return "";
        }
    }

    public static String toJson(Object o) {
        return Transformer.toJson(false, null, o);
    }

    public static String getJsonpResult(String callbackName, String jsonResult) {
        return callbackName + "(" + jsonResult + ");";
    }

    public static <T> T fromJson(String json, Class<T> c) {
        try {
            return (T)new Gson().fromJson(json, c);
        }
        catch (Exception e) {
            log.error((Object)("Error converting from JSON: " + e.getMessage()));
            return null;
        }
    }

    public static String toJson(Object o, GsonExclusionStrategy strategy) {
        try {
            Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{strategy}).create();
            return gson.toJson(o);
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            return "{}";
        }
    }
}

