/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.transform;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GsonExclusionStrategy
implements ExclusionStrategy {
    private Map<String, Set<String>> m = new HashMap<String, Set<String>>();

    public boolean shouldSkipField(FieldAttributes attrs) {
        String className = attrs.getDeclaringClass().getName();
        String fieldName = attrs.getName();
        if (this.m.containsKey(className)) {
            Set<String> fieldNames = this.m.get(className);
            return fieldNames == null ? false : fieldNames.contains(fieldName);
        }
        return false;
    }

    public boolean shouldSkipClass(Class<?> type) {
        return false;
    }

    public void addExclusionMapping(String fullyQualifiedClassName, String fieldName) {
        Set<String> fieldNames = this.m.get(fullyQualifiedClassName);
        if (fieldNames == null) {
            fieldNames = new HashSet<String>();
        }
        fieldNames.add(fieldName);
        this.m.put(fullyQualifiedClassName, fieldNames);
    }

    public void addExclusionMappings(Map<String, Set<String>> m) {
        m.putAll(m);
    }

    public Map<String, Set<String>> getExclusionMappings() {
        return this.m;
    }
}

