/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.sql;

import gov.grants.commons.sql.Literal;
import gov.grants.commons.sql.SQLString;
import gov.grants.commons.sql.Table;

public class WhereCondition
implements SQLString {
    private SQLString _operand1 = null;
    private SQLString _operand2 = null;
    private String _operator = null;

    private WhereCondition(String operator, SQLString operand1, SQLString operand2) {
        this._operator = operator;
        this._operand1 = operand1;
        this._operand2 = operand2;
    }

    public static WhereCondition createEquals(SQLString operand1, SQLString operand2) {
        return new WhereCondition("=", operand1, operand2);
    }

    public static WhereCondition createNotEquals(SQLString operand1, SQLString operand2) {
        return new WhereCondition("<>", operand1, operand2);
    }

    public static WhereCondition createLessThan(SQLString operand1, SQLString operand2) {
        return new WhereCondition("<", operand1, operand2);
    }

    public static WhereCondition createGreaterThan(SQLString operand1, SQLString operand2) {
        return new WhereCondition(">", operand1, operand2);
    }

    public static WhereCondition createLessOrEquals(SQLString operand1, SQLString operand2) {
        return new WhereCondition("<=", operand1, operand2);
    }

    public static WhereCondition createGreaterOrEquals(SQLString operand1, SQLString operand2) {
        return new WhereCondition(">=", operand1, operand2);
    }

    public static WhereCondition createLike(SQLString operand1, Literal operand2) {
        return new WhereCondition("LIKE", operand1, operand2);
    }

    public static WhereCondition createIsNull(Table.Column operand) {
        return new WhereCondition("IS", operand, Literal.NULL_LITERAL);
    }

    public static WhereCondition createIsNotNull(Table.Column operand) {
        return new WhereCondition("IS NOT", operand, Literal.NULL_LITERAL);
    }

    @Override
    public StringBuffer addString(StringBuffer buffer) {
        return this._operand2.addString(this._operand1.addString(buffer).append(" ").append(this._operator).append(" "));
    }
}

