/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.sql;

import gov.grants.commons.sql.Function;
import gov.grants.commons.sql.Group;
import gov.grants.commons.sql.Literal;
import gov.grants.commons.sql.SQLString;
import gov.grants.commons.sql.SelectBuilder;
import gov.grants.commons.sql.Table;
import gov.grants.commons.sql.TextLiteral;

public final class SetOperation
implements SQLString {
    private SQLString _operand1 = null;
    private SQLString _operand2 = null;
    private String _operator = null;

    private SetOperation(SQLString operand1, SQLString operand2, String operator) {
        this._operand1 = operand1;
        this._operand2 = operand2;
        this._operator = operator;
    }

    public static final SetOperation minus(SQLString operand1, SQLString operand2) {
        return new SetOperation(operand1, operand2, "MINUS");
    }

    public static final SetOperation union(SQLString operand1, SQLString operand2) {
        return new SetOperation(operand1, operand2, "UNION");
    }

    public static final SetOperation intersection(SQLString operand1, SQLString operand2) {
        return new SetOperation(operand1, operand2, "INTERSECTION");
    }

    @Override
    public StringBuffer addString(StringBuffer buffer) {
        return this._operand2.addString(this._operand1.addString(buffer.append("(")).append(") ").append(this._operator).append(" (")).append(")");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.addString(buffer);
        return buffer.toString();
    }

    public static void main(String[] args) {
        SelectBuilder select = new SelectBuilder();
        Table tstatus = select.addTable("tstatus");
        Table tformdata = select.addTable("tformdata");
        select.addColumn(tformdata.column("fundoppnumber"));
        select.addColumn(tstatus.column("processid"));
        select.addColumn(tstatus.column("status"));
        select.getWhereConditions().andEquals(tformdata.column("processid"), tstatus.column("processid"));
        select.getWhereConditions().andNotEquals(tstatus.column("status"), new TextLiteral("Purged"));
        select.getWhereConditions().andEquals(tformdata.column("agencyid"), new TextLiteral("HUD"));
        Group group = select.getWhereConditions().andGroup();
        group.andLessThan(new Function("length", tformdata.column("fundoppnumber")), new Literal("1"));
        group.orGreaterThan(new Function("length", tformdata.column("fundoppnumber")), new Literal("100"));
        SetOperation minus = SetOperation.minus(select, select);
        System.out.println(minus);
    }
}

