/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.sql;

import gov.grants.commons.sql.ConditionsGroup;
import gov.grants.commons.sql.Function;
import gov.grants.commons.sql.Group;
import gov.grants.commons.sql.Literal;
import gov.grants.commons.sql.OrderBy;
import gov.grants.commons.sql.SQLString;
import gov.grants.commons.sql.Table;
import gov.grants.commons.sql.TextLiteral;
import java.util.ArrayList;
import java.util.Iterator;

public final class SelectBuilder
implements SQLString {
    private ArrayList _tables = null;
    private ArrayList _columns = null;
    private ConditionsGroup _where = null;
    private OrderBy _orderby = null;

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.addString(buffer);
        return buffer.toString();
    }

    @Override
    public StringBuffer addString(StringBuffer buffer) {
        if (this._tables == null || this._columns == null) {
            return buffer;
        }
        buffer.append("select ");
        Iterator iter = this._columns.iterator();
        while (iter.hasNext()) {
            ((Table.Column)iter.next()).addString(buffer);
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(" from ");
        iter = this._tables.iterator();
        while (iter.hasNext()) {
            ((Table)iter.next()).addString(buffer);
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        if (this._where != null) {
            this._where.addString(buffer.append(" where "));
        }
        if (this._orderby != null) {
            this._orderby.addString(buffer.append(" "));
        }
        return buffer;
    }

    public Table addTable(String name) {
        Table table = new Table(name);
        if (this._tables == null) {
            this._tables = new ArrayList();
        }
        this._tables.add(table);
        return table;
    }

    public void addColumn(Table.Column column) {
        if (this._columns == null) {
            this._columns = new ArrayList();
        }
        this._columns.add(column);
    }

    public void addOrderBy(SQLString operand) {
        if (this._orderby == null) {
            this._orderby = new OrderBy(operand);
        } else {
            this._orderby.add(operand);
        }
    }

    public ConditionsGroup getWhereConditions() {
        if (this._where == null) {
            this._where = new ConditionsGroup();
        }
        return this._where;
    }

    public static void main(String[] args) {
        SelectBuilder select = new SelectBuilder();
        Table tstatus = select.addTable("tstatus");
        Table tformdata = select.addTable("tformdata");
        select.addColumn(tformdata.column("fundoppnumber"));
        select.addColumn(tstatus.column("processid"));
        select.addColumn(tstatus.column("status"));
        select.getWhereConditions().andEquals(tformdata.column("processid"), tstatus.column("processid"));
        select.getWhereConditions().andNotEquals(tstatus.column("status"), new TextLiteral("Purged"));
        select.getWhereConditions().andEquals(tformdata.column("agencyid"), new TextLiteral("HUD"));
        Group group = select.getWhereConditions().andGroup();
        group.andLessThan(new Function("length", tformdata.column("fundoppnumber")), new Literal("1"));
        group.orGreaterThan(new Function("length", tformdata.column("fundoppnumber")), new Literal("100"));
        select.addOrderBy(tformdata.column("fundoppnumber"));
        select.addOrderBy(tstatus.column("processid"));
        ArrayList<String> cfdaList = new ArrayList<String>();
        cfdaList.add("00.000");
        cfdaList.add("11.001");
        cfdaList.add("98.001");
        Group cfdaGroup = select.getWhereConditions().andGroup();
        cfdaGroup.orEquals(tformdata.column("cfda"), cfdaList, new TextLiteral(""));
        ArrayList<Table.Column> isNull = new ArrayList<Table.Column>();
        isNull.add(tformdata.column("fundoppnumber"));
        isNull.add(tstatus.column("processid"));
        Group isNullGroup = select.getWhereConditions().andGroup();
        isNullGroup.orIsNull(isNull);
        isNullGroup.andIsNotNull(isNull);
        System.out.println(select);
    }
}

