/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.security.cryptography;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class Cryptography {
    private static final Logger log = Logger.getLogger(Cryptography.class);
    private static Random rand = new Random(new Date().getTime());
    private static Key key;
    private static final byte[] salt;
    private static final int count = 20;

    public Cryptography() {
        log.debug((Object)"Cryptography implementation ...");
    }

    public Cryptography(String message) {
        try {
            log.debug((Object)("clear message: " + message));
            this.generateKey();
            String encrypted = Cryptography.encrypt(message);
            log.debug((Object)("encrypted message: " + encrypted));
            String decrypted = Cryptography.decrypt(encrypted);
            log.debug((Object)("decrypted message: " + decrypted));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String encrypt(String message) throws IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, UnsupportedEncodingException {
        return Cryptography.encrypt(message, false);
    }

    public static String encrypt(String message, boolean urlSafe) throws IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, UnsupportedEncodingException {
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(1, key);
        byte[] stringBytes = message.getBytes("UTF8");
        byte[] raw = cipher.doFinal(stringBytes);
        return Cryptography.base64Encode(raw, urlSafe);
    }

    public static String base64Encode(byte[] raw, boolean urlSafe) {
        String base64Str = null;
        base64Str = urlSafe ? Base64.encodeBase64URLSafeString((byte[])raw) : Base64.encodeBase64String((byte[])raw);
        return base64Str;
    }

    public static byte[] base64Decode(String base64Str) throws IOException {
        byte[] raw = Base64.decodeBase64((String)base64Str);
        return raw;
    }

    public static String decrypt(String encrypted) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException {
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(2, key);
        byte[] raw = Cryptography.base64Decode(encrypted);
        byte[] stringBytes = cipher.doFinal(raw);
        String clear = new String(stringBytes, "UTF8");
        return clear;
    }

    public static String pbeEncrypt(String message, String passPhrase) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        return Cryptography.pbeEncrypt(message, passPhrase, false);
    }

    public static String pbeEncrypt(String message, String passPhrase, boolean urlSafe) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 20);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(passPhrase.toCharArray());
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
        Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
        pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
        byte[] cleartext = message.getBytes();
        byte[] raw = pbeCipher.doFinal(cleartext);
        return Cryptography.base64Encode(raw, urlSafe);
    }

    public static String pbeDecrypt(String encrypted, String passPhrase) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, IOException {
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 20);
        PBEKeySpec pbeKeySpec = new PBEKeySpec(passPhrase.toCharArray());
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
        Cipher pbeCipher = Cipher.getInstance("PBEWithMD5AndDES");
        pbeCipher.init(2, (Key)pbeKey, pbeParamSpec);
        byte[] raw = Cryptography.base64Decode(encrypted);
        byte[] stringBytes = pbeCipher.doFinal(raw);
        String clearText = new String(stringBytes, "UTF8");
        return clearText;
    }

    public char[] readPasswd(InputStream in) throws IOException {
        char[] lineBuffer;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    public static String aesEncrypt(String s, String key, boolean urlSafe) {
        String encryptedStr = null;
        String algorithm = "AES";
        String cipherTx = "AES/ECB/PKCS5PADDING";
        try {
            SecretKeySpec aesKey = new SecretKeySpec(key.getBytes(), algorithm);
            Cipher cipher = Cipher.getInstance(cipherTx);
            cipher.init(1, aesKey);
            byte[] encrypted = cipher.doFinal(s.getBytes());
            encryptedStr = Cryptography.base64Encode(encrypted, urlSafe);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return encryptedStr;
    }

    public static String aesDecrypt(String base64Encoded, String key) {
        String decryptedStr = null;
        try {
            byte[] encrypted = Cryptography.base64Decode(base64Encoded);
            decryptedStr = Cryptography.aesDecryptString(encrypted, key);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return decryptedStr;
    }

    public static String aesDecryptString(byte[] encrypted, String key) {
        String decryptedStr = null;
        String algorithm = "AES";
        String cipherTx = "AES/ECB/PKCS5PADDING";
        try {
            SecretKeySpec aesKey = new SecretKeySpec(key.getBytes(), algorithm);
            Cipher cipher = Cipher.getInstance(cipherTx);
            cipher.init(2, aesKey);
            byte[] decrypted = cipher.doFinal(encrypted);
            decryptedStr = new String(decrypted);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return decryptedStr;
    }

    private void generateKey() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance("DES");
        generator.init(new SecureRandom());
        key = generator.generateKey();
    }

    static {
        salt = new byte[]{-57, 115, -28, -12, 126, -11, -24, -103};
    }
}

