/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.security.auth.callback;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.log4j.Logger;

public class UserIdPwdCallbackHandler
implements CallbackHandler {
    private static final Logger log = Logger.getLogger((String)UserIdPwdCallbackHandler.class.getName());
    private String userId = null;
    private char[] pwdArray = null;

    public UserIdPwdCallbackHandler(String userId, String password) {
        this.userId = userId;
        this.pwdArray = password.toCharArray();
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        log.debug((Object)("callbacks=" + callbacks));
        log.debug((Object)("number of callbacks=" + callbacks.length));
        for (int i = 0; i < callbacks.length; ++i) {
            log.debug((Object)("--- callback=" + callbacks[i].getClass().getName()));
            if (callbacks[i] instanceof NameCallback) {
                ((NameCallback)callbacks[i]).setName(this.userId);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                ((PasswordCallback)callbacks[i]).setPassword(this.pwdArray);
                continue;
            }
            log.error((Object)"ERROR: CALLBACK CLASS NOT SUPPORTED");
            throw new UnsupportedCallbackException(callbacks[i], "ERROR: CALLBACK CLASS NOT SUPPORTED");
        }
    }

    public void clearPassword() {
        this.pwdArray = null;
    }
}

