/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.s2s.xpath;

import gov.grants.commons.s2s.xpath.XPathExecutor;
import gov.grants.commons.test.BaseTest;
import gov.grants.commons.util.FileUtil;
import gov.grants.commons.util.Timer;
import java.io.InputStream;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Node;

public class XPathExecutorTest
extends BaseTest {
    private static final Logger log = Logger.getLogger((String)XPathExecutorTest.class.getName());
    private XPathExecutor xpathExe;
    private Timer timer;

    @Before
    public void setUp() {
        this.timer = new Timer();
        this.timer.start();
        this.artifactSubDir = "xpathExecutorTest/";
        InputStream inStream = null;
        String xmlFileName = "SingleProject.xml";
        String xmlFilePath = this.artifactSubDir + xmlFileName;
        String xmlStr = null;
        try {
            inStream = BaseTest.class.getResourceAsStream(xmlFilePath);
            byte[] xmlBytes = FileUtil.getBytes(inStream);
            log.debug((Object)("xmlBytes size: " + xmlBytes.length));
            xmlStr = new String(xmlBytes);
            log.debug((Object)("xmlStr length: " + xmlStr.length()));
            log.debug((Object)"create new XPathExecutor instance");
            this.xpathExe = new XPathExecutor(xmlStr);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed in setUp(): " + e.getMessage()));
        }
    }

    @After
    public void tearDown() {
        log.debug((Object)"--- tearDown()");
        this.timer.stop();
        log.debug((Object)("elapsed time(ms): " + this.timer.toMillisecondsLong()));
    }

    @Test
    public final void getNode() {
        Node hashNode = null;
        try {
            hashNode = this.xpathExe.getNode("//*[local-name(.) = 'GrantSubmissionHeader' and namespace-uri(.) = 'http://apply.grants.gov/system/Header-V1.0']/*[local-name(.) = 'HashValue' and namespace-uri(.) = 'http://apply.grants.gov/system/Global-V1.0']");
        }
        catch (TransformerException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((String)"The XPathExecutor did not return a Node.", (Object)hashNode);
        log.debug((Object)hashNode.getNodeName());
        Assert.assertEquals((String)"The XPathExecutor returned the wrong Node.", (Object)"glob:HashValue", (Object)hashNode.getNodeName());
    }
}

