/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.s2s.xpath;

import gov.grants.commons.s2s.xpath.GrantApplicationXpath;
import gov.grants.commons.test.BaseTest;
import gov.grants.commons.util.FileUtil;
import gov.grants.commons.util.Timer;
import javax.xml.transform.TransformerException;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Node;

public class GrantApplicationXpathTest
extends BaseTest {
    private static final Logger log = Logger.getLogger((String)GrantApplicationXpathTest.class.getName());
    private static final String SP_XML_HASH_VALUE = "uHL9N7oaf1L4+zQmcU+QYSnMLdU=";
    private GrantApplicationXpath singleProjGrantAppXpath = null;
    private Timer timer;

    @Before
    public void setUp() {
        this.timer = new Timer();
        this.timer.start();
        this.artifactSubDir = "grantApplicationXpathTest/";
        try {
            byte[] xmlBytes = null;
            String xmlFileName = "SingleProject.xml";
            String xmlFilePath = this.artifactSubDir + xmlFileName;
            xmlBytes = FileUtil.getBytes(BaseTest.class.getResourceAsStream(xmlFilePath));
            log.debug((Object)("single project xmlBytes size: " + xmlBytes.length));
            this.singleProjGrantAppXpath = new GrantApplicationXpath(new String(xmlBytes));
        }
        catch (Exception e) {
            log.error((Object)("Exception caught loading xml: " + e.getMessage()));
        }
    }

    @After
    public void tearDown() {
        log.debug((Object)"--- tearDown()");
        this.timer.stop();
        log.debug((Object)("elapsed time(ms): " + this.timer.toMillisecondsLong()));
    }

    @Test
    public final void getFormsNodeTest() {
        Node formsNode = null;
        try {
            formsNode = this.singleProjGrantAppXpath.getFormsNode();
        }
        catch (TransformerException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((String)"The GrantApplicationXpath did not return a Node.", (Object)formsNode);
        Assert.assertEquals((String)"The GrantApplicationXpath returned the wrong Node.", (String)"grant:Forms", (String)formsNode.getNodeName());
    }

    @Test
    public final void getHeaderNodeTest() {
        Node headerNode = null;
        try {
            headerNode = this.singleProjGrantAppXpath.getHeaderNode();
        }
        catch (TransformerException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((String)"The GrantApplicationXpath did not return a Node.", (Object)headerNode);
        Assert.assertEquals((String)"The GrantApplicationXpath returned the wrong Node.", (String)"header:GrantSubmissionHeader", (String)headerNode.getNodeName());
    }

    @Test
    public final void getHashNodeTest() {
        Node hashNode = null;
        try {
            hashNode = this.singleProjGrantAppXpath.getHashNode();
        }
        catch (TransformerException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((String)"The GrantApplicationXpath did not return a Node.", (Object)hashNode);
        Assert.assertEquals((String)"The GrantApplicationXpath returned the wrong Node.", (String)"glob:HashValue", (String)hashNode.getNodeName());
    }

    @Test
    public final void getHeaderHashValueTest() {
        String hashValue = null;
        try {
            hashValue = this.singleProjGrantAppXpath.getHeaderHashValue();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((String)"The GrantApplicationXpath returned an incorrect hash value for the Single-Project XML.", (String)SP_XML_HASH_VALUE, (String)hashValue);
    }
}

