/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.s2s.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public final class StringUtils {
    static final Logger log = Logger.getLogger((String)StringUtils.class.getName());
    static int[] scr_key = new int[]{28, 1, 3, 22, 26, 18, 2, 15, 31, 6, 24, 16, 20, 9, 27, 25, 19, 23, 5, 13, 0, 30, 4, 8, 11, 29, 21, 10, 14, 7, 17, 12};

    private StringUtils() {
    }

    public static String strReplace(String str, String oldPattern, String newPattern) {
        if (str == null) {
            return null;
        }
        int begin = 0;
        int end = 0;
        StringBuffer newString = new StringBuffer();
        while ((end = str.indexOf(oldPattern, begin)) >= 0) {
            newString.append(str.substring(begin, end));
            newString.append(newPattern);
            begin = end + oldPattern.length();
        }
        newString.append(str.substring(begin));
        return newString.toString();
    }

    public static String strReplaceIgnoreCase(String str, String oldPattern, String newPattern) {
        if (str == null) {
            return null;
        }
        int begin = 0;
        int end = 0;
        StringBuffer newString = new StringBuffer();
        String strLowerCase = str.toLowerCase();
        String oldPatternLowerCase = oldPattern.toLowerCase();
        while ((end = strLowerCase.indexOf(oldPatternLowerCase, begin)) >= 0) {
            newString.append(str.substring(begin, end));
            newString.append(newPattern);
            begin = end + oldPattern.length();
        }
        newString.append(str.substring(begin));
        return newString.toString();
    }

    public static String strTruncate(String str, int begin, int length) {
        if (str == null) {
            return str;
        }
        String newValue = null;
        int endIndex = begin + length;
        int strLength = str.length();
        newValue = endIndex >= strLength ? str.substring(begin) : str.substring(begin, endIndex).trim() + "...";
        return newValue;
    }

    public static String initUpperCase(String str) {
        if (str == null) {
            return null;
        }
        if (str == "" || str.length() < 1) {
            return str;
        }
        StringBuffer newString = new StringBuffer();
        String firstLetter = str.substring(0, 1);
        newString.append(firstLetter.toUpperCase()).append(str.substring(1));
        return newString.toString();
    }

    public static String setEmptyStrIfNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static List stringToList(String str, String delimiter) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(str, delimiter);
        String value = null;
        while (token.hasMoreTokens()) {
            value = token.nextToken();
            list.add(value);
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    public static String listToString(List list, String delimiter) {
        if (list == null || list.size() == 0) {
            return null;
        }
        int listCount = list.size();
        StringBuffer newString = new StringBuffer();
        String value = null;
        for (int i = 0; i < listCount; ++i) {
            value = (String)list.get(i);
            if (newString.length() > 0) {
                newString.append(delimiter).append(value);
                continue;
            }
            newString.append(value);
        }
        return newString.toString();
    }

    public static boolean listContainsIgnoreCase(List list, String comparisonString) {
        if (list == null || comparisonString == null || comparisonString.trim().length() < 1) {
            return false;
        }
        boolean containsComparisonString = false;
        String listElement = null;
        for (int i = 0; i < list.size(); ++i) {
            listElement = (String)list.get(i);
            if (!listElement.equalsIgnoreCase(comparisonString.trim())) continue;
            containsComparisonString = true;
            break;
        }
        return containsComparisonString;
    }

    public static int listIndexOfIgnoreCase(List list, String comparisonString) {
        int index = -1;
        String listElement = null;
        if (list == null || comparisonString == null || comparisonString.trim().length() < 1) {
            return index;
        }
        for (int i = 0; i < list.size(); ++i) {
            listElement = (String)list.get(i);
            if (!listElement.equalsIgnoreCase(comparisonString.trim())) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int indexOfIgnoreCase(String str, String fromIndex) {
        if (str == null || str.length() == 0) {
            return -1;
        }
        String lowerStr = str.toLowerCase();
        String lowerFromIndex = fromIndex.toLowerCase();
        return lowerStr.indexOf(lowerFromIndex);
    }

    public static String nullToEmptyString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String stringArrayToString(String[] strArray) {
        if (strArray == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int count = strArray.length;
        for (int i = 0; i < count; ++i) {
            if (sb.length() == 0) {
                sb.append(strArray[i]);
                continue;
            }
            sb.append(", ").append(strArray[i]);
        }
        return sb.toString();
    }

    public static float[] stringArrayToFloatArray(String[] strArray) {
        float[] floatArray = new float[strArray.length];
        if (strArray.length > 0) {
            floatArray = new float[strArray.length];
            for (int i = 0; i < strArray.length; ++i) {
                log.debug((Object)("==> " + i + "=" + strArray[i]));
                try {
                    floatArray[i] = Float.parseFloat(strArray[i]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    log.debug((Object)("==> INVALID FLOAT [" + strArray[i] + "] **"));
                    floatArray[i] = 0.0f;
                }
            }
            log.debug((Object)("==> floatArray.length=" + floatArray.length));
        }
        return floatArray;
    }

    public static String floatArrayToString(float[] floatArray) {
        if (floatArray == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int count = floatArray.length;
        for (int i = 0; i < count; ++i) {
            if (sb.length() == 0) {
                sb.append(floatArray[i]);
                continue;
            }
            sb.append(", ").append(floatArray[i]);
        }
        return sb.toString();
    }

    public static String makeSqlReady(String str) {
        if (str == null) {
            return null;
        }
        String ret = "";
        StringTokenizer st = new StringTokenizer(str, "'", true);
        while (st.hasMoreTokens()) {
            String t_str = st.nextToken();
            if (t_str.charAt(0) == '\'') {
                ret = ret + t_str + t_str;
                continue;
            }
            ret = ret + t_str;
        }
        return ret;
    }

    public static String makeSqlReadyHandleNull(String str) {
        String newString = StringUtils.makeSqlReady(str);
        if (newString != null) {
            return "'" + newString + "'";
        }
        return newString;
    }

    public static String encrypt(int cust_id) {
        long key = 691278383L;
        long[] data = new long[2];
        long[] my_ret = new long[4];
        data[0] = System.currentTimeMillis() / 1000L;
        data[1] = cust_id;
        byte[] my_seed = new byte[4];
        Random new_gen = new Random();
        new_gen.nextBytes(my_seed);
        long seed = my_ret[0] = (long)(my_seed[0] + 128) << 24 | (long)(my_seed[1] + 128 << 16) | (long)(my_seed[2] + 128 << 8) | (long)(my_seed[3] + 128);
        for (int i = 0; i < 2; ++i) {
            seed = StringUtils.scrumble(seed ^ data[i]);
            my_ret[i + 1] = seed ^ key;
        }
        String out_str = "";
        for (int i = 0; i < 3; ++i) {
            String t = Long.toHexString(my_ret[i]).toUpperCase();
            while (t.length() < 8) {
                t = "0" + t;
            }
            out_str = out_str + t;
        }
        return out_str;
    }

    private static long scrumble(long n) {
        long rv = 0L;
        for (int i = 0; i < 32; ++i) {
            rv |= (n >> i & 1L) << scr_key[i];
        }
        return rv;
    }

    public static String replaceQuestionMark(String baseString, String insertString) {
        int markLoc = 0;
        String returnString = null;
        markLoc = baseString.indexOf(63);
        if (markLoc == -1) {
            return null;
        }
        returnString = baseString.substring(0, markLoc) + insertString + baseString.substring(markLoc + 1, baseString.length());
        return returnString;
    }

    public static String extractDBval(String value) {
        return value != null ? value : "";
    }

    public static String escapeQuotes(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer strBuff = new StringBuffer(str);
        for (int pos = 0; pos < strBuff.length(); ++pos) {
            if (strBuff.charAt(pos) == '\'') {
                strBuff.replace(pos, pos + 1, "\\'");
                ++pos;
                continue;
            }
            if (strBuff.charAt(pos) != '\"') continue;
            strBuff.replace(pos, pos + 1, "\\\"");
            ++pos;
        }
        return strBuff.toString();
    }

    public static String getToString(Object obj) {
        StringBuffer toString = new StringBuffer();
        String methodName = null;
        try {
            Class<?> myClass = obj.getClass();
            Method[] methods = myClass.getDeclaredMethods();
            int count = methods.length;
            Method method = null;
            methodName = null;
            Object value = null;
            for (int i = 0; i < count; ++i) {
                method = methods[i];
                methodName = method.getName();
                if (!methodName.substring(0, 3).equals("get") || method.getParameterTypes().length != 0) continue;
                try {
                    value = method.invoke(obj, null);
                }
                catch (InvocationTargetException e) {
                    toString.append("I'm sorry  :-(  I cannot perform toString() for " + obj.getClass().getName() + " object, method name: " + methodName);
                }
                toString.append(System.getProperty("line.separator")).append("[").append(methodName).append("()=").append(value).append("]");
            }
        }
        catch (Exception e) {
            log.debug((Object)("ERROR :: Exception thrown:\n" + e + " :: cause ::  " + e.getMessage()));
            toString.append("I'm sorry  :-(  I cannot perform toString() for " + obj.getClass().getName() + " object, method name: " + methodName);
        }
        return toString.toString();
    }

    public static Object getObjectFromList(String fieldName, String value, List objList) {
        if (objList == null || objList.size() == 0 || fieldName == null || fieldName.length() == 0) {
            return null;
        }
        int count = objList.size();
        String requestedMethod = "get" + fieldName;
        Object obj = null;
        Class<?> myClass = null;
        Method[] methods = null;
        Method method2 = null;
        String methodName = null;
        int methodCount = 0;
        Object methodValue = null;
        try {
            for (int i = 0; i < count; ++i) {
                obj = objList.get(i);
                myClass = obj.getClass();
                for (Method method2 : myClass.getDeclaredMethods()) {
                    methodName = method2.getName();
                    if (!methodName.equalsIgnoreCase(requestedMethod) || method2.getParameterTypes().length != 0 || !value.equalsIgnoreCase(String.valueOf(methodValue = method2.invoke(obj, null)))) continue;
                    return obj;
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)("ERROR :: Exception thrown:\n" + e + " :: cause ::  " + e.getMessage()));
        }
        return null;
    }

    public static boolean isString(Object obj) {
        if (obj == null) {
            return true;
        }
        return String.class.isInstance(obj);
    }
}

