/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.s2s.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SoapUtil {
    private static final Logger log = Logger.getLogger((String)SoapUtil.class.getName());
    private static Properties props = null;
    public static final String SOAP_HOST_KEY = "SOAP_HOST";
    public static final String SOAP_PORT_KEY = "SOAP_PORT";
    public static final String ENCODING_TYPE_KEY = "ENCODING_TYPE";
    public static final String MIME_ENCODING_KEY = "MIME";
    public static final String DIME_ENCODING_KEY = "DIME";
    private static String CONFIG_PROPERTIES_FILE = null;
    private static String SOAP_URL = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getProperty(String key) throws IOException {
        log.debug((Object)("find property for key=" + key));
        if (props != null) return props.getProperty(key);
        Class<SoapUtil> clazz = SoapUtil.class;
        synchronized (SoapUtil.class) {
            if (props != null) return props.getProperty(key);
            props = SoapUtil.loadProperties();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return props.getProperty(key);
        }
    }

    private static Properties loadProperties() throws IOException {
        Properties props = new Properties();
        InputStream stream = null;
        try {
            if (SoapUtil.getConfigPropertiesFile() != null) {
                File f = new File(SoapUtil.getConfigPropertiesFile());
                log.debug((Object)("soap properties file=" + f.getAbsolutePath()));
                if (f.exists()) {
                    log.debug((Object)("SOAP_Server.properties file loaded from " + SoapUtil.getConfigPropertiesFile()));
                    stream = new FileInputStream(f);
                } else {
                    stream = SoapUtil.class.getResourceAsStream("/" + CONFIG_PROPERTIES_FILE);
                    log.debug((Object)"SOAP_Server.properties file loaded from classes dir on classpath");
                }
                log.debug((Object)"Loading soap properties");
                props.load(stream);
                log.debug((Object)"soap properties loaded successfully");
            } else {
                log.error((Object)"Cannot find property file");
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
        return props;
    }

    public static String getSoapURL() throws IOException {
        if (StringUtils.isBlank((String)SOAP_URL)) {
            log.debug((Object)"Generating SOAP URL");
            String soapHost = SoapUtil.getProperty(SOAP_HOST_KEY);
            String soapPort = SoapUtil.getProperty(SOAP_PORT_KEY);
            if (!soapHost.endsWith("/") && !soapPort.startsWith("/")) {
                soapHost = soapHost + "/";
            }
            String soapUrl = soapHost + soapPort;
            log.debug((Object)("returning SOAP URL: " + soapUrl));
            return soapUrl;
        }
        log.debug((Object)("returning SOAP URL: " + SOAP_URL));
        return SOAP_URL;
    }

    public static String getConfigPropertiesFile() {
        log.debug((Object)("==>configPropertiesFile=" + CONFIG_PROPERTIES_FILE));
        return CONFIG_PROPERTIES_FILE;
    }

    public static void setConfigPropertiesFile(String configPropertiesFile) {
        CONFIG_PROPERTIES_FILE = configPropertiesFile;
    }

    public static void setSoapUrl(String soapUrl) {
        SOAP_URL = soapUrl;
    }
}

