/*
 * Decompiled with CFR 0.152.
 */
package gov.grants.commons.s2s.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class PropertiesLoader {
    private static final Logger LOG = Logger.getLogger(PropertiesLoader.class);
    private static final HashMap _cache = new HashMap();

    public static String list(String file) {
        Properties prop = PropertiesLoader._getProperties(file);
        if (prop == null) {
            return "No such properties file: " + file;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        prop.list(pw);
        pw.flush();
        sw.flush();
        String value = sw.toString();
        try {
            pw.close();
            sw.close();
        }
        catch (IOException e) {
            LOG.warn((Object)"Could not close PrintWriter and/or StringWriter instances.", (Throwable)e);
        }
        return value;
    }

    public static URL getURLValue(String file, String key) throws MalformedURLException {
        String value = PropertiesLoader.getValue(file, key);
        if (value == null) {
            return null;
        }
        return new URL(value);
    }

    public static boolean getBooleanValue(String file, String key) {
        String value = PropertiesLoader.getValue(file, key);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    public static int getIntValue(String file, String key) {
        String value = PropertiesLoader.getValue(file, key);
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public static String getValue(String file, String key) {
        Object value = null;
        Properties props = PropertiesLoader._getProperties(file);
        if (props != null) {
            value = props.get(key);
        } else if (props == null && LOG.isInfoEnabled()) {
            LOG.info((Object)("No such properties file " + file + " in classpath"));
        }
        if (value == null && (value = System.getProperty(key)) == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No such property " + key + " in properties file " + file + " or within the System.properties"));
            }
            return null;
        }
        return value.toString();
    }

    private static synchronized Properties _getProperties(String file) {
        if (file == null || "SYSTEM".equals(file)) {
            return System.getProperties();
        }
        Properties props = (Properties)_cache.get(file);
        if (props != null) {
            return props;
        }
        InputStream stream = PropertiesLoader.class.getClassLoader().getResourceAsStream(file);
        if (stream != null) {
            props = new Properties();
            try {
                props.load(stream);
            }
            catch (IOException e) {
                LOG.warn((Object)"Unable to load properties file.", (Throwable)e);
                return null;
            }
            _cache.put(file, props);
            return props;
        }
        return null;
    }
}

